/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.java;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.impl.java.JavaClassTreeElementBase;
import com.intellij.ide.util.treeView.smartTree.SortableTreeElement;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class PsiFieldTreeElement
extends JavaClassTreeElementBase<PsiField>
implements SortableTreeElement {
    public PsiFieldTreeElement(PsiField field, boolean isInherited) {
        super(isInherited, field);
    }

    @Override
    @NotNull
    public Collection<StructureViewTreeElement> getChildrenBase() {
        return Collections.emptyList();
    }

    public String getPresentableText() {
        PsiField field = (PsiField)this.getElement();
        if (field == null) {
            return "";
        }
        boolean dumb = DumbService.isDumb((Project)field.getProject());
        return StringUtil.replace((String)PsiFormatUtil.formatVariable((PsiVariable)field, (int)(1 | (dumb ? 0 : 2) | 4 | (dumb ? 0 : 128)), (PsiSubstitutor)PsiSubstitutor.EMPTY), (String)":", (String)": ");
    }

    public PsiField getField() {
        return (PsiField)this.getElement();
    }

    @NotNull
    public String getAlphaSortKey() {
        String name;
        PsiField field = (PsiField)this.getElement();
        if (field != null && (name = field.getName()) != null) {
            return name;
        }
        return "";
    }
}

