/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl.xml;

import com.intellij.ide.structureView.StructureViewExtension;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TextEditorBasedStructureViewModel;
import com.intellij.ide.structureView.impl.xml.DtdFileTreeElement;
import com.intellij.ide.structureView.impl.xml.XmlFileTreeElement;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.lang.dtd.DTDLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttlistDecl;
import com.intellij.psi.xml.XmlConditionalSection;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlStructureViewTreeModel
extends TextEditorBasedStructureViewModel {
    private static final Class[] CLASSES = new Class[]{XmlTag.class, XmlFile.class, XmlEntityDecl.class, XmlElementDecl.class, XmlAttlistDecl.class, XmlConditionalSection.class};
    private static final Sorter[] SORTERS = new Sorter[]{Sorter.ALPHA_SORTER};

    public XmlStructureViewTreeModel(@NotNull XmlFile file2, @Nullable Editor editor) {
        super(editor, (PsiFile)file2);
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        XmlFile myFile = this.getPsiFile();
        if (myFile.getLanguage() == DTDLanguage.INSTANCE) {
            return new DtdFileTreeElement(myFile);
        }
        return new XmlFileTreeElement(myFile);
    }

    public boolean shouldEnterElement(Object element) {
        return element instanceof XmlTag && ((XmlTag)element).getSubTags().length > 0;
    }

    protected XmlFile getPsiFile() {
        return (XmlFile)super.getPsiFile();
    }

    @NotNull
    protected Class[] getSuitableClasses() {
        return CLASSES;
    }

    public Object getCurrentEditorElement() {
        Object editorElement = super.getCurrentEditorElement();
        if (editorElement instanceof XmlTag) {
            PsiUtilCore.ensureValid((PsiElement)((XmlTag)editorElement));
            for (StructureViewExtension extension : StructureViewFactoryEx.getInstanceEx(this.getPsiFile().getProject()).getAllExtensions(XmlTag.class)) {
                Object element = extension.getCurrentEditorElement(this.getEditor(), (PsiElement)editorElement);
                if (element == null) continue;
                return element;
            }
        }
        return editorElement;
    }

    @NotNull
    public Sorter[] getSorters() {
        return SORTERS;
    }
}

