/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.newStructureView;

import com.intellij.ide.structureView.FileEditorPositionListener;
import com.intellij.ide.structureView.ModelListener;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.newStructureView.TreeActionsOwner;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TreeModelWrapper
implements StructureViewModel,
ProvidingTreeModel {
    private final StructureViewModel myModel;
    private final TreeActionsOwner myStructureView;

    public TreeModelWrapper(@NotNull StructureViewModel model, @NotNull TreeActionsOwner structureView) {
        this.myModel = model;
        this.myStructureView = structureView;
    }

    @NotNull
    public StructureViewTreeElement getRoot() {
        return this.myModel.getRoot();
    }

    @NotNull
    public Grouper[] getGroupers() {
        List filtered = this.filterActive((TreeAction[])this.myModel.getGroupers());
        return filtered.toArray(new Grouper[filtered.size()]);
    }

    @NotNull
    private <T extends TreeAction> List<T> filterActive(@NotNull T[] actions) {
        ArrayList<T> filtered = new ArrayList<T>();
        for (T action : actions) {
            if (!this.isFiltered((TreeAction)action)) continue;
            filtered.add(action);
        }
        return filtered;
    }

    @NotNull
    private List<NodeProvider> filterProviders(@NotNull Collection<NodeProvider> actions) {
        ArrayList<NodeProvider> filtered = new ArrayList<NodeProvider>();
        for (NodeProvider action : actions) {
            if (!this.isFiltered((TreeAction)action)) continue;
            filtered.add(action);
        }
        return filtered;
    }

    private boolean isFiltered(@NotNull TreeAction action) {
        return action instanceof Sorter && !((Sorter)action).isVisible() || this.myStructureView.isActionActive(action.getName());
    }

    @NotNull
    public Sorter[] getSorters() {
        List filtered = this.filterActive((TreeAction[])this.myModel.getSorters());
        return filtered.toArray(new Sorter[filtered.size()]);
    }

    @NotNull
    public Filter[] getFilters() {
        List filtered = this.filterActive((TreeAction[])this.myModel.getFilters());
        return filtered.toArray(new Filter[filtered.size()]);
    }

    public Object getCurrentEditorElement() {
        return this.myModel.getCurrentEditorElement();
    }

    @NotNull
    public Collection<NodeProvider> getNodeProviders() {
        if (this.myModel instanceof ProvidingTreeModel) {
            return this.filterProviders(((ProvidingTreeModel)this.myModel).getNodeProviders());
        }
        return Collections.emptyList();
    }

    public static boolean isActive(@NotNull TreeAction action, @NotNull TreeActionsOwner actionsOwner) {
        if (TreeModelWrapper.shouldRevert(action)) {
            return !actionsOwner.isActionActive(action.getName());
        }
        return action instanceof Sorter && !((Sorter)action).isVisible() || actionsOwner.isActionActive(action.getName());
    }

    public static boolean shouldRevert(@NotNull TreeAction action) {
        return action instanceof Filter && ((Filter)action).isReverted();
    }

    public void addEditorPositionListener(@NotNull FileEditorPositionListener listener2) {
        this.myModel.addEditorPositionListener(listener2);
    }

    public void removeEditorPositionListener(@NotNull FileEditorPositionListener listener2) {
        this.myModel.removeEditorPositionListener(listener2);
    }

    public void dispose() {
        this.myModel.dispose();
    }

    public boolean shouldEnterElement(Object element) {
        return false;
    }

    public void addModelListener(@NotNull ModelListener modelListener) {
        this.myModel.addModelListener(modelListener);
    }

    public void removeModelListener(@NotNull ModelListener modelListener) {
        this.myModel.removeModelListener(modelListener);
    }

    public StructureViewModel getModel() {
        return this.myModel;
    }

    public boolean isEnabled(@NotNull NodeProvider provider2) {
        return this.myStructureView.isActionActive(provider2.getName());
    }
}

