/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.configurable;

import com.intellij.application.options.colors.ColorAndFontDescription;
import com.intellij.application.options.colors.ColorAndFontDescriptionPanel;
import com.intellij.application.options.colors.TextAttributesDescription;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorSchemeAttributeDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.psi.search.TodoAttributes;
import com.intellij.psi.search.TodoAttributesUtil;
import com.intellij.psi.search.TodoPattern;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.FormBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

class PatternDialog
extends DialogWrapper {
    private final TodoPattern myPattern;
    private final ComboBox<Icon> myIconComboBox;
    private final JBCheckBox myCaseSensitiveCheckBox;
    private final JBTextField myPatternStringField;
    private final ColorAndFontDescriptionPanel myColorAndFontDescriptionPanel;
    private final ColorAndFontDescription myColorAndFontDescription;
    private final JBCheckBox myUsedDefaultColorsCheckBox;

    public PatternDialog(Component parent, TodoPattern pattern) {
        super(parent, true);
        this.setTitle(IdeBundle.message((String)"title.add.todo.pattern", (Object[])new Object[0]));
        this.setResizable(false);
        TodoAttributes attrs = pattern.getAttributes();
        this.myPattern = pattern;
        this.myIconComboBox = new ComboBox((Object[])new Icon[]{AllIcons.General.TodoDefault, AllIcons.General.TodoQuestion, AllIcons.General.TodoImportant});
        this.myIconComboBox.setSelectedItem((Object)attrs.getIcon());
        this.myIconComboBox.setRenderer((ListCellRenderer)new ListCellRendererWrapper<Icon>(){

            public void customize(JList list, Icon value2, int index, boolean selected, boolean hasFocus) {
                this.setIcon(value2);
                this.setText(" ");
            }
        });
        this.myCaseSensitiveCheckBox = new JBCheckBox(IdeBundle.message((String)"checkbox.case.sensitive", (Object[])new Object[0]), pattern.isCaseSensitive());
        this.myPatternStringField = new JBTextField(pattern.getPatternString());
        this.myUsedDefaultColorsCheckBox = new JBCheckBox(IdeBundle.message((String)"checkbox.todo.use.default.colors", (Object[])new Object[0]));
        this.myUsedDefaultColorsCheckBox.setSelected(!attrs.shouldUseCustomTodoColor());
        this.myColorAndFontDescriptionPanel = new ColorAndFontDescriptionPanel();
        TextAttributes attributes = this.myPattern.getAttributes().getCustomizedTextAttributes();
        this.myColorAndFontDescription = new TextAttributesDescription("null", null, attributes, null, EditorColorsManager.getInstance().getGlobalScheme(), null, null){

            @Override
            public boolean isErrorStripeEnabled() {
                return true;
            }

            @Override
            public boolean isEditable() {
                return true;
            }
        };
        this.myColorAndFontDescriptionPanel.reset((EditorSchemeAttributeDescriptor)this.myColorAndFontDescription);
        this.updateCustomColorsPanel();
        this.myUsedDefaultColorsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PatternDialog.this.updateCustomColorsPanel();
            }
        });
        this.init();
    }

    private void updateCustomColorsPanel() {
        if (this.useCustomTodoColor()) {
            this.myColorAndFontDescriptionPanel.reset((EditorSchemeAttributeDescriptor)this.myColorAndFontDescription);
        } else {
            this.myColorAndFontDescriptionPanel.resetDefault();
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPatternStringField;
    }

    protected void doOKAction() {
        this.myPattern.setPatternString(this.myPatternStringField.getText().trim());
        this.myPattern.setCaseSensitive(this.myCaseSensitiveCheckBox.isSelected());
        TodoAttributes attrs = this.myPattern.getAttributes();
        attrs.setIcon((Icon)this.myIconComboBox.getSelectedItem());
        attrs.setUseCustomTodoColor(this.useCustomTodoColor(), TodoAttributesUtil.getDefaultColorSchemeTextAttributes());
        if (this.useCustomTodoColor()) {
            this.myColorAndFontDescriptionPanel.apply((EditorSchemeAttributeDescriptor)this.myColorAndFontDescription, null);
        }
        super.doOKAction();
    }

    private boolean useCustomTodoColor() {
        return !this.myUsedDefaultColorsCheckBox.isSelected();
    }

    protected JComponent createCenterPanel() {
        return FormBuilder.createFormBuilder().addLabeledComponent(IdeBundle.message((String)"label.todo.pattern", (Object[])new Object[0]), (JComponent)this.myPatternStringField).addLabeledComponent(IdeBundle.message((String)"label.todo.icon", (Object[])new Object[0]), this.myIconComboBox).addComponent((JComponent)this.myCaseSensitiveCheckBox).addComponent((JComponent)this.myUsedDefaultColorsCheckBox).addComponent((JComponent)this.myColorAndFontDescriptionPanel).getPanel();
    }
}

