/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionsTopHitProvider
implements SearchTopHitProvider {
    @NotNull
    public abstract Collection<BooleanOptionDescription> getOptions(@Nullable Project var1);

    private Collection<BooleanOptionDescription> getCachedOptions(@Nullable Project project2) {
        Project manager;
        Object object = manager = project2 != null ? project2 : ApplicationManager.getApplication();
        if (manager == null) {
            return Collections.emptyList();
        }
        CachedOptions cache2 = (CachedOptions)manager.getUserData(CachedOptions.KEY);
        if (cache2 == null) {
            cache2 = new CachedOptions((ComponentManager)manager);
        }
        return cache2.map.computeIfAbsent(this.getClass(), type2 -> this.getOptions(project2));
    }

    public final void consumeTopHits(@NonNls String pattern, Consumer<Object> collector, Project project2) {
        if (!pattern.startsWith("#")) {
            return;
        }
        List parts = StringUtil.split((String)(pattern = pattern.substring(1)), (String)" ");
        if (parts.size() == 0) {
            return;
        }
        String id = (String)parts.get(0);
        if (this.getId().startsWith(id) || pattern.startsWith(" ")) {
            pattern = pattern.startsWith(" ") ? pattern.trim() : pattern.substring(id.length()).trim().toLowerCase();
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + pattern), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
            for (BooleanOptionDescription option : this.getCachedOptions(project2)) {
                if (!matcher.matches(option.getOption())) continue;
                collector.consume((Object)option);
            }
        }
    }

    public abstract String getId();

    public boolean isEnabled(@Nullable Project project2) {
        return true;
    }

    static String messageApp(String property) {
        return StringUtil.stripHtml((String)ApplicationBundle.message((String)property, (Object[])new Object[0]), (boolean)false);
    }

    static String messageIde(String property) {
        return StringUtil.stripHtml((String)IdeBundle.message((String)property, (Object[])new Object[0]), (boolean)false);
    }

    static String messageKeyMap(String property) {
        return StringUtil.stripHtml((String)KeyMapBundle.message((String)property, (Object[])new Object[0]), (boolean)false);
    }

    private static final class CachedOptions
    implements Disposable {
        private static final Key<CachedOptions> KEY = Key.create((String)"cached top hits");
        private final ConcurrentHashMap<Class<?>, Collection<BooleanOptionDescription>> map = new ConcurrentHashMap();
        private final ComponentManager manager;

        private CachedOptions(ComponentManager manager) {
            this.manager = manager;
            Disposer.register((Disposable)manager, (Disposable)this);
            manager.putUserData(KEY, (Object)this);
        }

        public void dispose() {
            this.manager.putUserData(KEY, null);
            this.map.values().forEach(CachedOptions::dispose);
        }

        private static void dispose(Collection<BooleanOptionDescription> options) {
            if (options != null) {
                options.forEach(CachedOptions::dispose);
            }
        }

        private static void dispose(BooleanOptionDescription option) {
            if (option instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)option));
            }
        }
    }

    @Deprecated
    public static interface CoveredByToggleActions {
    }
}

