/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui;

import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.RegistryBooleanOptionDescriptor;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryOptionsTopHitProvider
extends OptionsTopHitProvider {
    @Override
    @NotNull
    public Collection<BooleanOptionDescription> getOptions(@Nullable Project project2) {
        return Holder.ourValues;
    }

    @Override
    public boolean isEnabled(@Nullable Project project2) {
        return ApplicationManager.getApplication().isInternal();
    }

    @Override
    public String getId() {
        return "registry";
    }

    private static class Holder {
        private static final List<BooleanOptionDescription> ourValues = Holder.initValues();

        private Holder() {
        }

        private static List<BooleanOptionDescription> initValues() {
            ArrayList<BooleanOptionDescription> result2 = new ArrayList<BooleanOptionDescription>();
            for (RegistryValue value2 : Registry.getAll()) {
                if (!value2.isBoolean()) continue;
                String key2 = value2.getKey();
                RegistryBooleanOptionDescriptor optionDescriptor = new RegistryBooleanOptionDescriptor(key2, key2);
                if (value2.isChangedFromDefault()) {
                    result2.add(0, optionDescriptor);
                    continue;
                }
                result2.add(optionDescriptor);
            }
            return result2;
        }
    }
}

