/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.laf.DarculaMetalTheme;
import com.intellij.ide.ui.laf.IdeaLaf;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColorUtil;
import com.intellij.util.Alarm;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import sun.awt.AppContext;

public class DarculaLaf
extends BasicLookAndFeel {
    private static final Object SYSTEM = new Object();
    public static final String NAME = "Darcula";
    BasicLookAndFeel base = this.createBaseLookAndFeel();
    private static Disposable myDisposable;
    private static Alarm myMnemonicAlarm;
    private static boolean myAltPressed;

    private static void installMacOSXFonts(UIDefaults defaults) {
        String face = "HelveticaNeue-Regular";
        FontUIResource uiFont = DarculaLaf.getFont("HelveticaNeue-Regular", 13, 0);
        LafManagerImpl.initFontDefaults(defaults, 13, uiFont);
        for (Object key2 : new HashSet(defaults.keySet())) {
            FontUIResource font;
            Object value2 = defaults.get(key2);
            if (!(value2 instanceof FontUIResource) || !(font = (FontUIResource)value2).getFamily().equals("Lucida Grande") && !font.getFamily().equals("Serif") || key2.toString().contains("Menu")) continue;
            defaults.put(key2, DarculaLaf.getFont("HelveticaNeue-Regular", font.getSize(), font.getStyle()));
        }
        FontUIResource uiFont11 = DarculaLaf.getFont("HelveticaNeue-Regular", 11, 0);
        defaults.put("TableHeader.font", uiFont11);
        FontUIResource buttonFont = DarculaLaf.getFont("HelveticaNeue-Medium", 13, 0);
        defaults.put("Button.font", buttonFont);
        FontUIResource menuFont = DarculaLaf.getFont("Lucida Grande", 14, 0);
        defaults.put("Menu.font", menuFont);
        defaults.put("MenuItem.font", menuFont);
        defaults.put("MenuItem.acceleratorFont", menuFont);
        defaults.put("PasswordField.font", defaults.getFont("TextField.font"));
    }

    @NotNull
    private static FontUIResource getFont(String yosemite, int size, @JdkConstants.FontStyle int style) {
        Font font;
        if (SystemInfo.isMacOSElCapitan && !UIUtil.isDialogFont((Font)(font = new Font(".SF NS Text", style, size)))) {
            return new FontUIResource(font);
        }
        return new FontUIResource(yosemite, style, size);
    }

    protected BasicLookAndFeel createBaseLookAndFeel() {
        try {
            if (SystemInfo.isMac) {
                String name = UIManager.getSystemLookAndFeelClassName();
                return (BasicLookAndFeel)Class.forName(name).newInstance();
            }
            return new IdeaLaf();
        }
        catch (Exception e) {
            DarculaLaf.log(e);
            return null;
        }
    }

    private void callInit(String method2, UIDefaults defaults) {
        try {
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod(method2, UIDefaults.class);
            superMethod.setAccessible(true);
            superMethod.invoke((Object)this.base, defaults);
        }
        catch (Exception e) {
            DarculaLaf.log(e);
        }
    }

    protected static void log(Exception e) {
        e.printStackTrace();
    }

    @Override
    public UIDefaults getDefaults() {
        try {
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod("getDefaults", new Class[0]);
            superMethod.setAccessible(true);
            UIDefaults metalDefaults = (UIDefaults)superMethod.invoke((Object)new MetalLookAndFeel(), new Object[0]);
            UIDefaults defaults = (UIDefaults)superMethod.invoke((Object)this.base, new Object[0]);
            if (SystemInfo.isLinux) {
                if (!Registry.is((String)"darcula.use.native.fonts.on.linux")) {
                    Font font = DarculaLaf.findFont("DejaVu Sans");
                    if (font != null) {
                        for (Object key2 : defaults.keySet()) {
                            if (!(key2 instanceof String) || !((String)key2).endsWith(".font")) continue;
                            defaults.put(key2, new FontUIResource(font.deriveFont(13.0f)));
                        }
                    }
                } else if (Arrays.asList("CN", "JP", "KR", "TW").contains(Locale.getDefault().getCountry())) {
                    for (Object key3 : defaults.keySet()) {
                        Font font;
                        if (!(key3 instanceof String) || !((String)key3).endsWith(".font") || (font = defaults.getFont(key3)) == null) continue;
                        defaults.put(key3, new FontUIResource("Dialog", font.getStyle(), font.getSize()));
                    }
                }
            }
            LafManagerImpl.initInputMapDefaults(defaults);
            this.initIdeaDefaults(defaults);
            this.patchStyledEditorKit(defaults);
            DarculaLaf.patchComboBox(metalDefaults, defaults);
            defaults.remove("Spinner.arrowButtonBorder");
            defaults.put("Spinner.arrowButtonSize", JBUI.size((int)16, (int)5).asUIResource());
            MetalLookAndFeel.setCurrentTheme(this.createMetalTheme());
            if (SystemInfo.isWindows && Registry.is((String)"ide.win.frame.decoration")) {
                JFrame.setDefaultLookAndFeelDecorated(true);
                JDialog.setDefaultLookAndFeelDecorated(true);
            }
            if (SystemInfo.isLinux && JBUI.isUsrHiDPI()) {
                DarculaLaf.applySystemFonts(defaults);
            }
            defaults.put("EditorPane.font", defaults.getFont("TextField.font"));
            if (SystemInfo.isMacOSYosemite) {
                DarculaLaf.installMacOSXFonts(defaults);
            }
            return defaults;
        }
        catch (Exception e) {
            DarculaLaf.log(e);
            return super.getDefaults();
        }
    }

    private static void applySystemFonts(UIDefaults defaults) {
        try {
            String fqn = UIUtil.getSystemLookAndFeelClassName();
            Object systemLookAndFeel = Class.forName(fqn).newInstance();
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod("getDefaults", new Class[0]);
            superMethod.setAccessible(true);
            UIDefaults systemDefaults = (UIDefaults)superMethod.invoke(systemLookAndFeel, new Object[0]);
            for (Map.Entry entry : systemDefaults.entrySet()) {
                if (!(entry.getValue() instanceof Font)) continue;
                defaults.put(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            DarculaLaf.log(e);
        }
    }

    protected DefaultMetalTheme createMetalTheme() {
        return new DarculaMetalTheme();
    }

    private static Font findFont(String name) {
        for (Font font : GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            if (!font.getName().equals(name)) continue;
            return font;
        }
        return null;
    }

    private static void patchComboBox(UIDefaults metalDefaults, UIDefaults defaults) {
        defaults.remove("ComboBox.ancestorInputMap");
        defaults.remove("ComboBox.actionMap");
        defaults.put("ComboBox.ancestorInputMap", metalDefaults.get("ComboBox.ancestorInputMap"));
        defaults.put("ComboBox.actionMap", metalDefaults.get("ComboBox.actionMap"));
    }

    private void patchStyledEditorKit(UIDefaults defaults) {
        URL url = this.getClass().getResource(this.getPrefix() + (JBUI.isUsrHiDPI() ? "@2x.css" : ".css"));
        StyleSheet styleSheet = UIUtil.loadStyleSheet((URL)url);
        defaults.put("StyledEditorKit.JBDefaultStyle", styleSheet);
        try {
            Field keyField = HTMLEditorKit.class.getDeclaredField("DEFAULT_STYLES_KEY");
            keyField.setAccessible(true);
            AppContext.getAppContext().put(keyField.get(null), UIUtil.loadStyleSheet((URL)url));
        }
        catch (Exception e) {
            DarculaLaf.log(e);
        }
    }

    protected String getPrefix() {
        return "darcula";
    }

    private void call(String method2) {
        try {
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod(method2, new Class[0]);
            superMethod.setAccessible(true);
            superMethod.invoke((Object)this.base, new Object[0]);
        }
        catch (Exception ignore) {
            DarculaLaf.log(ignore);
        }
    }

    @Override
    public void initComponentDefaults(UIDefaults defaults) {
        this.callInit("initComponentDefaults", defaults);
    }

    protected void initIdeaDefaults(UIDefaults defaults) {
        this.loadDefaults(defaults);
        defaults.put("Table.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "meta C", "copy", "ctrl V", "paste", "meta V", "paste", "ctrl X", "cut", "meta X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "PAGE_UP", "scrollUpChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "HOME", "selectFirstColumn", "END", "selectLastColumn", "shift PAGE_UP", "scrollUpExtendSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "shift HOME", "selectFirstColumnExtendSelection", "shift END", "selectLastColumnExtendSelection", "ctrl PAGE_UP", "scrollLeftChangeSelection", "ctrl PAGE_DOWN", "scrollRightChangeSelection", "ctrl HOME", "selectFirstRow", "ctrl END", "selectLastRow", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "shift ENTER", "selectPreviousRowCell", "ctrl A", "selectAll", "meta A", "selectAll", "ESCAPE", "cancel", "F2", "startEditing"}));
    }

    protected void loadDefaults(UIDefaults defaults) {
        Properties properties = new Properties();
        String osSuffix = SystemInfo.isMac ? "mac" : (SystemInfo.isWindows ? "windows" : "linux");
        try {
            String darculaKey;
            Object value2;
            InputStream stream = this.getClass().getResourceAsStream(this.getPrefix() + ".properties");
            properties.load(stream);
            stream.close();
            stream = this.getClass().getResourceAsStream(this.getPrefix() + "_" + osSuffix + ".properties");
            properties.load(stream);
            stream.close();
            HashMap darculaGlobalSettings = new HashMap();
            String prefix = this.getPrefix() + ".";
            for (String key2 : properties.stringPropertyNames()) {
                if (!key2.startsWith(prefix)) continue;
                value2 = this.parseValue(key2, properties.getProperty(key2));
                darculaKey = key2.substring(prefix.length());
                if (value2 == SYSTEM) {
                    darculaGlobalSettings.remove((Object)darculaKey);
                    continue;
                }
                darculaGlobalSettings.put((Object)darculaKey, value2);
            }
            for (String key2 : defaults.keySet()) {
                String s;
                if (!(key2 instanceof String) || !key2.contains(".") || !darculaGlobalSettings.containsKey((Object)(darculaKey = (s = key2).substring(s.lastIndexOf(46) + 1)))) continue;
                defaults.put(key2, darculaGlobalSettings.get((Object)darculaKey));
            }
            for (String key2 : properties.stringPropertyNames()) {
                value2 = properties.getProperty(key2);
                defaults.put(key2, this.parseValue(key2, (String)value2));
            }
        }
        catch (IOException e) {
            DarculaLaf.log(e);
        }
    }

    protected Object parseValue(String key2, @NotNull String value2) {
        if ("null".equals(value2)) {
            return null;
        }
        if ("system".equals(value2)) {
            return SYSTEM;
        }
        if (key2.endsWith("Insets")) {
            return DarculaLaf.parseInsets(value2);
        }
        if (key2.endsWith("Border") || key2.endsWith("border")) {
            try {
                if (StringUtil.split((String)value2, (String)",").size() == 4) {
                    return new BorderUIResource.EmptyBorderUIResource(DarculaLaf.parseInsets(value2));
                }
                return Class.forName(value2).newInstance();
            }
            catch (Exception e) {
                DarculaLaf.log(e);
            }
        } else {
            Icon icon;
            if (key2.endsWith("Size")) {
                return DarculaLaf.parseSize(value2);
            }
            Color color = DarculaLaf.parseColor(value2);
            Integer invVal = DarculaLaf.getInteger(value2);
            Boolean boolVal = "true".equals(value2) ? Boolean.TRUE : ("false".equals(value2) ? Boolean.FALSE : null);
            Icon icon2 = icon = value2.startsWith("AllIcons.") ? IconLoader.getIcon((String)value2) : null;
            if (icon == null && value2.endsWith(".png")) {
                icon = IconLoader.findIcon((String)value2, DarculaLaf.class, (boolean)true);
            }
            if (color != null) {
                return new ColorUIResource(color);
            }
            if (invVal != null) {
                return invVal;
            }
            if (icon != null) {
                return new IconUIResource(icon);
            }
            if (boolVal != null) {
                return boolVal;
            }
        }
        return value2;
    }

    private static Insets parseInsets(String value2) {
        List numbers = StringUtil.split((String)value2, (String)",");
        return new JBInsets(Integer.parseInt((String)numbers.get(0)), Integer.parseInt((String)numbers.get(1)), Integer.parseInt((String)numbers.get(2)), Integer.parseInt((String)numbers.get(3))).asUIResource();
    }

    private static Color parseColor(String value2) {
        if (value2 != null && value2.length() == 8) {
            Color color = ColorUtil.fromHex((String)value2.substring(0, 6));
            if (color != null) {
                try {
                    int alpha = Integer.parseInt(value2.substring(6, 8), 16);
                    return new ColorUIResource(new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
        return ColorUtil.fromHex((String)value2, null);
    }

    private static Integer getInteger(String value2) {
        try {
            return Integer.parseInt(value2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static Dimension parseSize(String value2) {
        List numbers = StringUtil.split((String)value2, (String)",");
        return new JBDimension(Integer.parseInt((String)numbers.get(0)), Integer.parseInt((String)numbers.get(1))).asUIResource();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getID() {
        return this.getName();
    }

    @Override
    public String getDescription() {
        return "IntelliJ Dark Look and Feel";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return true;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults defaults) {
        this.callInit("initSystemColorDefaults", defaults);
    }

    @Override
    protected void initClassDefaults(UIDefaults defaults) {
        this.callInit("initClassDefaults", defaults);
    }

    @Override
    public void initialize() {
        try {
            this.base.initialize();
        }
        catch (Exception exception) {
            // empty catch block
        }
        myDisposable = Disposer.newDisposable();
        Application application = ApplicationManager.getApplication();
        if (application != null) {
            Disposer.register((Disposable)application, (Disposable)myDisposable);
        }
        myMnemonicAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, myDisposable);
        IdeEventQueue.getInstance().addDispatcher(e -> {
            if (e instanceof KeyEvent && ((KeyEvent)e).getKeyCode() == 18) {
                myAltPressed = e.getID() == 401;
                myMnemonicAlarm.cancelAllRequests();
                Component focusOwner = IdeFocusManager.findInstance().getFocusOwner();
                if (focusOwner != null) {
                    myMnemonicAlarm.addRequest(() -> DarculaLaf.repaintMnemonics(focusOwner, myAltPressed), 10);
                }
            }
            return false;
        }, myDisposable);
    }

    public static boolean isAltPressed() {
        return myAltPressed;
    }

    private static void repaintMnemonics(@NotNull Component focusOwner, boolean pressed) {
        if (pressed != myAltPressed) {
            return;
        }
        Window window = SwingUtilities.windowForComponent(focusOwner);
        if (window != null) {
            for (Component component : window.getComponents()) {
                if (!(component instanceof JComponent)) continue;
                for (JComponent c : UIUtil.findComponentsOfType((JComponent)((JComponent)component), JComponent.class)) {
                    if ((!(c instanceof JLabel) || ((JLabel)c).getDisplayedMnemonicIndex() == -1) && (!(c instanceof AbstractButton) || ((AbstractButton)c).getDisplayedMnemonicIndex() == -1)) continue;
                    c.repaint();
                }
            }
        }
    }

    @Override
    public void uninitialize() {
        try {
            this.base.initialize();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Disposer.dispose((Disposable)myDisposable);
        myDisposable = null;
    }

    @Override
    protected void loadSystemColors(UIDefaults defaults, String[] systemColors, boolean useNative) {
        try {
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod("loadSystemColors", UIDefaults.class, String[].class, Boolean.TYPE);
            superMethod.setAccessible(true);
            superMethod.invoke((Object)this.base, defaults, systemColors, useNative);
        }
        catch (Exception ignore) {
            DarculaLaf.log(ignore);
        }
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return true;
    }

    public static Icon loadIcon(String iconName) {
        return IconLoader.findIcon((String)("/com/intellij/ide/ui/laf/icons/" + iconName), DarculaLaf.class, (boolean)true);
    }
}

