/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MacUIUtil;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.KeyEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class DarculaUIUtil {
    private static final Color GLOW_COLOR = new JBColor(new Color(31, 121, 212), new Color(96, 175, 255));
    private static final Color ACTIVE_ERROR_COLOR = new JBColor(() -> {
        if (SystemInfo.isMac && UIUtil.isUnderIntelliJLaF()) {
            return new Color(-2130768113, true);
        }
        return UIUtil.isUnderDarcula() ? new Color(9124924) : new Color(15023693);
    });
    private static final Color INACTIVE_ERROR_COLOR = new JBColor(() -> {
        if (SystemInfo.isMac && UIUtil.isUnderIntelliJLaF()) {
            return new Color(-2131580246, true);
        }
        return UIUtil.isUnderDarcula() ? new Color(0x725252) : new Color(0xEBBCBC);
    });
    private static final Color BALLOON_BORDER = new JBColor(new Color(14723241), new Color(7554379));
    private static final Color BALLOON_BACKGROUND = new JBColor(new Color(16115431), new Color(5848385));

    public static void paintFocusRing(Graphics g, Rectangle bounds) {
        MacUIUtil.paintFocusRing((Graphics2D)((Graphics2D)g), (Color)GLOW_COLOR, (Rectangle)bounds);
    }

    public static void paintFocusOval(Graphics g, int x, int y, int width, int height) {
        MacUIUtil.paintFocusRing((Graphics2D)((Graphics2D)g), (Color)GLOW_COLOR, (Rectangle)new Rectangle(x, y, width, height), (boolean)true);
    }

    public static void paintSearchFocusRing(Graphics2D g, Rectangle bounds, Component component) {
        DarculaUIUtil.paintSearchFocusRing(g, bounds, component, -1);
    }

    public static void paintSearchFocusRing(Graphics2D g, Rectangle bounds, Component component, int maxArcSize) {
        int correction = UIUtil.isUnderAquaLookAndFeel() ? 30 : (UIUtil.isUnderDarcula() ? 50 : 0);
        Color[] colors = new Color[]{ColorUtil.toAlpha((Color)GLOW_COLOR, (int)(180 - correction)), ColorUtil.toAlpha((Color)GLOW_COLOR, (int)(120 - correction)), ColorUtil.toAlpha((Color)GLOW_COLOR, (int)(70 - correction)), ColorUtil.toAlpha((Color)GLOW_COLOR, (int)(100 - correction)), ColorUtil.toAlpha((Color)GLOW_COLOR, (int)(50 - correction))};
        Object oldAntialiasingValue = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        Object oldStrokeControlValue = g.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
        Rectangle r = new Rectangle(bounds.x - 3, bounds.y - 3, bounds.width + 6, bounds.height + 6);
        int arcSize = r.height - 1;
        if (maxArcSize > 0) {
            arcSize = Math.min(maxArcSize, arcSize);
        }
        if (arcSize % 2 == 1) {
            --arcSize;
        }
        g.setColor(component.getBackground());
        g.fillRoundRect(r.x + 2, r.y + 2, r.width - 5, r.height - 5, arcSize - 4, arcSize - 4);
        g.setColor(colors[0]);
        g.drawRoundRect(r.x + 2, r.y + 2, r.width - 5, r.height - 5, arcSize - 4, arcSize - 4);
        g.setColor(colors[1]);
        g.drawRoundRect(r.x + 1, r.y + 1, r.width - 3, r.height - 3, arcSize - 2, arcSize - 2);
        g.setColor(colors[2]);
        g.drawRoundRect(r.x, r.y, r.width - 1, r.height - 1, arcSize, arcSize);
        g.setColor(colors[3]);
        g.drawRoundRect(r.x + 3, r.y + 3, r.width - 7, r.height - 7, arcSize - 6, arcSize - 6);
        g.setColor(colors[4]);
        g.drawRoundRect(r.x + 4, r.y + 4, r.width - 9, r.height - 9, arcSize - 8, arcSize - 8);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAntialiasingValue);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, oldStrokeControlValue);
    }

    public static void paintErrorBorder(Graphics2D g, int width, int height, boolean hasFocus) {
        int lw = SystemInfo.isMac && UIUtil.isUnderIntelliJLaF() ? JBUI.scale((int)3) : JBUI.scale((int)2);
        RoundRectangle2D.Double shape = new RoundRectangle2D.Double(lw, lw, width - lw * 2, height - lw * 2, lw, lw);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, MacUIUtil.USE_QUARTZ ? RenderingHints.VALUE_STROKE_PURE : RenderingHints.VALUE_STROKE_NORMALIZE);
        g.setPaint(hasFocus ? ACTIVE_ERROR_COLOR : INACTIVE_ERROR_COLOR);
        g.setStroke(new OuterStroke(lw));
        g.draw(shape);
    }

    public static boolean isCurrentEventShiftDownEvent() {
        AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
        return event instanceof KeyEvent && ((KeyEvent)event).isShiftDown();
    }

    public static void showErrorTip(JComponent component) {
        BalloonBuilder bb = (BalloonBuilder)component.getClientProperty("JComponent.error.balloonBuilder");
        if (bb != null) {
            component.putClientProperty("JComponent.error.balloonBuilder", null);
            Balloon balloon = bb.setPointerSize((Dimension)new JBDimension(17, 6)).setCornerToPointerDistance(JBUI.scale((int)30)).setBorderColor(BALLOON_BORDER).setFillColor(BALLOON_BACKGROUND).setHideOnFrameResize(false).setRequestFocus(false).setAnimationCycle(300).setShadow(false).createBalloon();
            JRootPane root = component.getRootPane();
            Point componentPos = SwingUtilities.convertPoint(component, 0, 0, root);
            Dimension bSize = balloon.getPreferredSize();
            if (componentPos.y >= bSize.height) {
                balloon.show((PositionTracker)new PositionTracker<Balloon>((Component)component){

                    public RelativePoint recalculateLocation(Balloon balloon) {
                        return new RelativePoint(this.getComponent(), new Point(JBUI.scale((int)60), 0));
                    }
                }, Balloon.Position.above);
            } else {
                balloon.show((PositionTracker)new PositionTracker<Balloon>((Component)component){

                    public RelativePoint recalculateLocation(Balloon balloon) {
                        return new RelativePoint(this.getComponent(), new Point(JBUI.scale((int)60), this.getComponent().getHeight()));
                    }
                }, Balloon.Position.below);
            }
        }
    }

    public static int getPatchedNextVisualPositionFrom(JTextComponent t, int pos, int direction) {
        if (!DarculaUIUtil.isCurrentEventShiftDownEvent()) {
            if (direction == 7 && t.getSelectionStart() < t.getSelectionEnd() && t.getSelectionEnd() == pos) {
                return t.getSelectionStart();
            }
            if (direction == 3 && t.getSelectionStart() < t.getSelectionEnd() && t.getSelectionStart() == pos) {
                return t.getSelectionEnd();
            }
        }
        return -1;
    }

    private static class OuterStroke
    implements Stroke {
        private final BasicStroke stroke;

        private OuterStroke(float width) {
            this.stroke = new BasicStroke(width);
        }

        @Override
        public Shape createStrokedShape(Shape s) {
            float lw = this.stroke.getLineWidth();
            float delta = lw / 2.0f;
            if (s instanceof Rectangle2D) {
                Rectangle2D rs = (Rectangle2D)s;
                return this.stroke.createStrokedShape(new Rectangle2D.Double(rs.getX() - (double)delta, rs.getY() - (double)delta, rs.getWidth() + (double)lw, rs.getHeight() + (double)lw));
            }
            if (s instanceof RoundRectangle2D) {
                RoundRectangle2D rrs = (RoundRectangle2D)s;
                return this.stroke.createStrokedShape(new RoundRectangle2D.Double(rrs.getX() - (double)delta, rrs.getY() - (double)delta, rrs.getWidth() + (double)lw, rrs.getHeight() + (double)lw, rrs.getArcWidth() + (double)lw, rrs.getArcHeight() + (double)lw));
            }
            throw new UnsupportedOperationException("Shape is not supported");
        }
    }
}

