/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.darcula.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.laf.darcula.ui.DarculaRootPaneUI;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.imgscalr.Scalr;
import sun.swing.SwingUtilities2;

public class DarculaTitlePane
extends JComponent {
    private static final int IMAGE_HEIGHT = 16;
    private static final int IMAGE_WIDTH = 16;
    private static final JBColor BUTTON_HOVER_BG = new JBColor(0xE5E5E5, 0x55585A);
    private PropertyChangeListener myPropertyChangeListener;
    private JMenuBar myMenuBar;
    private JMenuBar myIdeMenu;
    private Action myCloseAction;
    private Action myIconifyAction;
    private Action myRestoreAction;
    private Action myMaximizeAction;
    private JButton myToggleButton;
    private JButton myIconifyButton;
    private JButton myCloseButton;
    private JButton myHelpButton;
    private Icon myMaximizeIcon;
    private Icon myMinimizeIcon;
    private Image mySystemIcon;
    private WindowListener myWindowListener;
    private Window myWindow;
    private JRootPane myRootPane;
    private int myState;
    private DarculaRootPaneUI rootPaneUI;
    private Color myInactiveBackground = UIManager.getColor("inactiveCaption");
    private Color myInactiveForeground = UIManager.getColor("inactiveCaptionText");
    private Color myInactiveShadow = UIManager.getColor("inactiveCaptionBorder");
    private Color myActiveBackground = null;
    private Color myActiveForeground = null;
    private Color myActiveShadow = null;

    public DarculaTitlePane(JRootPane root, DarculaRootPaneUI ui) {
        this.myRootPane = root;
        this.rootPaneUI = ui;
        this.myState = -1;
        this.installSubcomponents();
        this.determineColors();
        this.installDefaults();
        this.setLayout(this.createLayout());
        this.setBorder((Border)JBUI.Borders.empty((int)3, (int)0));
    }

    private void uninstall() {
        this.uninstallListeners();
        this.myWindow = null;
        this.removeAll();
    }

    private void installListeners() {
        if (this.myWindow != null) {
            this.myWindowListener = this.createWindowListener();
            this.myWindow.addWindowListener(this.myWindowListener);
            this.myPropertyChangeListener = this.createWindowPropertyChangeListener();
            this.myWindow.addPropertyChangeListener(this.myPropertyChangeListener);
        }
    }

    private void uninstallListeners() {
        if (this.myWindow != null) {
            this.myWindow.removeWindowListener(this.myWindowListener);
            this.myWindow.removePropertyChangeListener(this.myPropertyChangeListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    @Override
    public JRootPane getRootPane() {
        return this.myRootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.myWindow = SwingUtilities.getWindowAncestor(this);
        if (this.myWindow != null) {
            if (this.myWindow instanceof Frame) {
                this.setState(((Frame)this.myWindow).getExtendedState());
            } else {
                this.setState(0);
            }
            this.setActive(this.myWindow.isActive());
            this.installListeners();
            this.updateSystemIcon();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.myWindow = null;
    }

    private void installSubcomponents() {
        int decorationStyle = this.getWindowDecorationStyle();
        if (decorationStyle == 1) {
            this.createActions();
            this.myMenuBar = this.createMenuBar();
            if (this.myRootPane instanceof IdeRootPane) {
                this.myIdeMenu = new IdeMenuBar(ActionManagerEx.getInstanceEx(), DataManager.getInstance());
                this.add(this.myIdeMenu);
            }
            this.add(this.myMenuBar);
            this.createButtons();
            this.add(this.myHelpButton);
            this.add(this.myIconifyButton);
            this.add(this.myToggleButton);
            this.add(this.myCloseButton);
        } else if (decorationStyle == 2 || decorationStyle == 3 || decorationStyle == 4 || decorationStyle == 5 || decorationStyle == 6 || decorationStyle == 7 || decorationStyle == 8) {
            this.createActions();
            this.createButtons();
            this.add(this.myHelpButton);
            this.add(this.myCloseButton);
        }
    }

    private void determineColors() {
        switch (this.getWindowDecorationStyle()) {
            case 1: {
                this.myActiveBackground = UIManager.getColor("activeCaption");
                this.myActiveForeground = UIManager.getColor("activeCaptionText");
                this.myActiveShadow = UIManager.getColor("activeCaptionBorder");
                break;
            }
            case 4: {
                this.myActiveBackground = new Color(43, 43, 43);
                this.myActiveForeground = UIManager.getColor("OptionPane.errorDialog.titlePane.foreground");
                this.myActiveShadow = UIManager.getColor("OptionPane.errorDialog.titlePane.shadow");
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.myActiveBackground = new Color(43, 43, 43);
                this.myActiveForeground = UIManager.getColor("OptionPane.questionDialog.titlePane.foreground");
                this.myActiveShadow = UIManager.getColor("OptionPane.questionDialog.titlePane.shadow");
                break;
            }
            case 8: {
                this.myActiveBackground = new Color(43, 43, 43);
                this.myActiveForeground = UIManager.getColor("OptionPane.warningDialog.titlePane.foreground");
                this.myActiveShadow = UIManager.getColor("OptionPane.warningDialog.titlePane.shadow");
                break;
            }
            default: {
                this.myActiveBackground = new Color(43, 43, 43);
                this.myActiveForeground = UIManager.getColor("activeCaptionText");
                this.myActiveShadow = UIManager.getColor("activeCaptionBorder");
            }
        }
        this.myActiveBackground = new Color(43, 43, 43);
        this.myActiveForeground = JBColor.foreground();
        this.myActiveShadow = UIManager.getColor("activeCaptionBorder");
    }

    private void installDefaults() {
        this.setFont((Font)JBUI.Fonts.label().asBold());
    }

    protected JMenuBar createMenuBar() {
        this.myMenuBar = new SystemMenuBar();
        this.myMenuBar.setOpaque(false);
        this.myMenuBar.setFocusable(false);
        this.myMenuBar.setBorderPainted(true);
        this.myMenuBar.add(this.createMenu());
        return this.myMenuBar;
    }

    private void close() {
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.myState | 1);
        }
    }

    private void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.myState | 6);
        }
    }

    private void restore() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((this.myState & 1) != 0) {
            frame.setExtendedState(this.myState & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.myState & 0xFFFFFFF9);
        }
    }

    private void createActions() {
        this.myCloseAction = new CloseAction();
        if (this.getWindowDecorationStyle() == 1) {
            this.myIconifyAction = new IconifyAction();
            this.myRestoreAction = new RestoreAction();
            this.myMaximizeAction = new MaximizeAction();
        }
    }

    private JMenu createMenu() {
        JMenu menu = new JMenu("");
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(menu);
        }
        return menu;
    }

    private void addMenuItems(JMenu menu) {
        menu.add(this.myRestoreAction);
        menu.add(this.myIconifyAction);
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            menu.add(this.myMaximizeAction);
        }
        menu.add(new JSeparator());
        menu.add(this.myCloseAction);
    }

    private static JButton createButton(String accessibleName, Icon icon, Icon hoverIcon, Action action, Color hoverBg) {
        return new WindowButton(accessibleName, icon, hoverIcon, action, hoverBg);
    }

    private void createButtons() {
        this.myCloseButton = DarculaTitlePane.createButton("Close", AllIcons.Windows.CloseActive, AllIcons.Windows.CloseHover, this.myCloseAction, Color.red);
        if (this.getWindowDecorationStyle() == 1) {
            this.myMaximizeIcon = AllIcons.Windows.MaximizeInactive;
            this.myMinimizeIcon = AllIcons.Windows.MinimizeInactive;
            this.myIconifyButton = DarculaTitlePane.createButton("Iconify", AllIcons.Windows.MinimizeInactive, AllIcons.Windows.Minimize, this.myIconifyAction, (Color)BUTTON_HOVER_BG);
            this.myToggleButton = DarculaTitlePane.createButton("Maximize", AllIcons.Windows.MaximizeInactive, AllIcons.Windows.MaximizeInactive, this.myRestoreAction, (Color)BUTTON_HOVER_BG);
        }
        this.myHelpButton = this.createHelpButton();
    }

    private JButton createHelpButton() {
        final Ref button = Ref.create();
        button.set((Object)new WindowButton("Help", AllIcons.Windows.HelpButton, AllIcons.Windows.HelpButton, new AbstractAction("Help"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogWrapper dialog2 = DialogWrapper.findInstance((Component)((Component)button.get()));
                if (dialog2 != null) {
                    try {
                        Method getHelpAction = DialogWrapper.class.getDeclaredMethod("getHelpAction", new Class[0]);
                        getHelpAction.setAccessible(true);
                        Object helpAction = getHelpAction.invoke((Object)dialog2, new Object[0]);
                        if (helpAction instanceof Action && ((Action)helpAction).isEnabled()) {
                            ((Action)helpAction).actionPerformed(e);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }, (Color)BUTTON_HOVER_BG){
            {
                this.setFont(new Font("Segoe UI Regular", 0, JBUI.scale((int)15)));
            }

            @Override
            public void paint(Graphics g) {
                if (this.isHelpAvailable()) {
                    super.paint(g);
                } else {
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
            }

            private boolean isHelpAvailable() {
                DialogWrapper dialog2 = DialogWrapper.findInstance((Component)this);
                if (dialog2 != null) {
                    try {
                        Method getHelpAction = DialogWrapper.class.getDeclaredMethod("getHelpAction", new Class[0]);
                        getHelpAction.setAccessible(true);
                        Object helpAction = getHelpAction.invoke((Object)dialog2, new Object[0]);
                        if (helpAction instanceof Action && ((Action)helpAction).isEnabled()) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return false;
            }
        });
        return (JButton)button.get();
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean active) {
        this.myCloseButton.putClientProperty("paintActive", active);
        if (this.getWindowDecorationStyle() == 1) {
            this.myIconifyButton.putClientProperty("paintActive", active);
            this.myToggleButton.putClientProperty("paintActive", active);
        }
        this.getRootPane().repaint();
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        Window wnd = this.getWindow();
        if (wnd != null && this.getWindowDecorationStyle() == 1) {
            if (this.myState == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane rootPane = this.getRootPane();
                if ((state & 6) != 0 && (rootPane.getBorder() == null || rootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    rootPane.setBorder(null);
                } else if ((state & 6) == 0) {
                    this.rootPaneUI.installBorder(rootPane);
                }
                if (frame.isResizable()) {
                    if ((state & 6) != 0) {
                        this.updateToggleButton(this.myRestoreAction, this.myMinimizeIcon);
                        this.myMaximizeAction.setEnabled(false);
                        this.myRestoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.myMaximizeAction, this.myMaximizeIcon);
                        this.myMaximizeAction.setEnabled(true);
                        this.myRestoreAction.setEnabled(false);
                    }
                    if (this.myToggleButton.getParent() == null || this.myIconifyButton.getParent() == null) {
                        this.add(this.myToggleButton);
                        this.add(this.myIconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.myToggleButton.setText(null);
                } else {
                    this.myMaximizeAction.setEnabled(false);
                    this.myRestoreAction.setEnabled(false);
                    if (this.myToggleButton.getParent() != null) {
                        this.remove(this.myToggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.myMaximizeAction.setEnabled(false);
                this.myRestoreAction.setEnabled(false);
                this.myIconifyAction.setEnabled(false);
                this.remove(this.myToggleButton);
                this.remove(this.myIconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.myCloseAction.setEnabled(true);
            this.myState = state;
        }
    }

    private void updateToggleButton(Action action, Icon icon) {
        this.myToggleButton.setAction(action);
        this.myToggleButton.setIcon(icon);
        this.myToggleButton.setText(null);
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Window getWindow() {
        return this.myWindow;
    }

    private String getTitle() {
        Window w = this.getWindow();
        if (w instanceof Frame) {
            return ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).getTitle();
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        String theTitle;
        int xOffset;
        Color foreground;
        Color background;
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        JRootPane rootPane = this.getRootPane();
        Window window = this.getWindow();
        boolean leftToRight = window == null ? rootPane.getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
        boolean isSelected = window == null ? true : window.isActive();
        int width = this.getWidth();
        int height = this.getHeight();
        if (isSelected) {
            background = UIUtil.getPanelBackground();
            foreground = this.myActiveForeground;
            Gray darkShadow = Gray._73;
        } else {
            background = UIUtil.getPanelBackground();
            foreground = this.myInactiveForeground;
            Color darkShadow = this.myInactiveShadow;
        }
        g.setColor(background);
        g.fillRect(0, 0, width, height);
        int n = xOffset = leftToRight ? JBUI.scale((int)5) : width - JBUI.scale((int)5);
        if (this.getWindowDecorationStyle() == 1 && this.myMenuBar != null) {
            int menuBarWithOffset = this.myMenuBar.getWidth() + JBUI.scale((int)5);
            xOffset += leftToRight ? menuBarWithOffset : -menuBarWithOffset;
        }
        if ((theTitle = this.getTitle()) != null) {
            FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)rootPane, g);
            g.setColor(foreground);
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            if (this.myIconifyButton != null && this.myIconifyButton.getParent() != null) {
                rect = this.myIconifyButton.getBounds();
            }
            if (leftToRight) {
                if (rect.x == 0) {
                    rect.x = window.getWidth() - window.getInsets().right - 2;
                }
                int titleW = rect.x - xOffset - 4;
                theTitle = SwingUtilities2.clipStringIfNecessary(rootPane, fm, theTitle, titleW);
            } else {
                int titleW = xOffset - rect.x - rect.width - 4;
                theTitle = SwingUtilities2.clipStringIfNecessary(rootPane, fm, theTitle, titleW);
                xOffset -= SwingUtilities2.stringWidth(rootPane, fm, theTitle);
            }
            int titleLength = SwingUtilities2.stringWidth(rootPane, fm, theTitle);
            if (this.myIdeMenu == null) {
                SwingUtilities2.drawString((JComponent)rootPane, g, theTitle, xOffset, yOffset);
                xOffset += leftToRight ? titleLength + JBUI.scale((int)5) : -JBUI.scale((int)5);
            }
        }
        g.setColor(UIManager.getColor("MenuBar.darcula.borderColor"));
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    private void updateSystemIcon() {
        Window window = this.getWindow();
        if (window == null) {
            this.mySystemIcon = null;
            return;
        }
        List<Image> icons = window.getIconImages();
        assert (icons != null);
        if (icons.size() == 0) {
            this.mySystemIcon = null;
        } else if (icons.size() == 1) {
            this.mySystemIcon = icons.get(0);
        } else {
            JBDimension size = JBUI.size((int)16);
            Image image = icons.get(0);
            this.mySystemIcon = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage((Image)image), (Scalr.Method)Scalr.Method.ULTRA_QUALITY, (int)size.width, (int)size.height, (BufferedImageOp[])new BufferedImageOp[0]);
        }
    }

    static class WindowButton
    extends JButton {
        private final Icon myHoverIcon;
        private final Color myHoverBg;
        boolean mouseOverButton = false;

        WindowButton(String accessibleName, Icon icon, Icon hoverIcon, Action action, Color hoverBg) {
            this.myHoverIcon = hoverIcon;
            this.myHoverBg = hoverBg;
            this.enableEvents(16L);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    mouseOverButton = true;
                    this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    mouseOverButton = false;
                    this.repaint();
                }
            });
            this.setFocusPainted(false);
            this.setFocusable(false);
            this.setOpaque(true);
            this.putClientProperty("paintActive", Boolean.TRUE);
            this.putClientProperty("AccessibleName", accessibleName);
            this.setBorder((Border)JBUI.Borders.empty());
            this.setText(null);
            this.setAction(action);
            this.setIcon(icon);
        }

        @Override
        public void paint(Graphics g) {
            if (this.mouseOverButton) {
                g.setColor(this.myHoverBg);
            } else {
                g.setColor(this.getBackground());
            }
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            IconUtil.paintInCenterOf((Component)this, (Graphics)g, (Icon)(this.mouseOverButton ? this.myHoverIcon : this.getIcon()));
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent ev) {
            DarculaTitlePane.this.setActive(true);
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
            DarculaTitlePane.this.setActive(false);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = DarculaTitlePane.this.getFrame();
                if (frame != null) {
                    DarculaTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    DarculaTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                DarculaTitlePane.this.repaint();
            } else if ("componentOrientation" == name) {
                DarculaTitlePane.this.revalidate();
                DarculaTitlePane.this.repaint();
            } else if ("iconImage" == name) {
                DarculaTitlePane.this.updateSystemIcon();
                DarculaTitlePane.this.revalidate();
                DarculaTitlePane.this.repaint();
            }
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight();
            return new Dimension(-1, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        private int computeHeight() {
            FontMetrics fm = DarculaTitlePane.this.myRootPane.getFontMetrics(DarculaTitlePane.this.getFont());
            int fontHeight = fm.getHeight();
            fontHeight += 7;
            int iconHeight = 0;
            if (DarculaTitlePane.this.getWindowDecorationStyle() == 1) {
                iconHeight = 16;
            }
            return Math.max(Math.max(fontHeight, iconHeight), JBUI.scale((int)31));
        }

        @Override
        public void layoutContainer(Container c) {
            int spacing;
            int w = DarculaTitlePane.this.getWidth();
            int h = DarculaTitlePane.this.getHeight();
            int buttonHeight = JBUI.scale((int)29);
            int buttonWidth = JBUI.scale((int)45);
            int x = spacing = JBUI.scale((int)5);
            if (DarculaTitlePane.this.myMenuBar != null) {
                DarculaTitlePane.this.myMenuBar.setBounds(x, (h - JBUI.scale((int)16)) / 2, JBUI.scale((int)16), JBUI.scale((int)16));
            }
            int systemIconSize = DarculaTitlePane.this.mySystemIcon == null ? JBUI.scale((int)16) : DarculaTitlePane.this.mySystemIcon.getWidth(null);
            x = buttonHeight - systemIconSize + systemIconSize + systemIconSize / 2;
            if (DarculaTitlePane.this.myIdeMenu != null) {
                Dimension size = DarculaTitlePane.this.myIdeMenu.getPreferredSize();
                DarculaTitlePane.this.myIdeMenu.setBounds(x, (h - size.height) / 2, size.width, size.height);
            }
            x = w;
            spacing = 0;
            x -= spacing + buttonWidth;
            if (DarculaTitlePane.this.myCloseButton != null) {
                DarculaTitlePane.this.myCloseButton.setBounds(x, (h - buttonHeight) / 2, buttonWidth, buttonHeight);
            }
            if (DarculaTitlePane.this.getWindowDecorationStyle() == 1) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && DarculaTitlePane.this.myToggleButton.getParent() != null) {
                    DarculaTitlePane.this.myToggleButton.setBounds(x -= spacing + buttonWidth, (h - buttonHeight) / 2, buttonWidth, buttonHeight);
                }
                if (DarculaTitlePane.this.myIconifyButton != null && DarculaTitlePane.this.myIconifyButton.getParent() != null) {
                    DarculaTitlePane.this.myIconifyButton.setBounds(x -= spacing + buttonWidth, (h - buttonHeight) / 2, buttonWidth, buttonHeight);
                }
            }
            DarculaTitlePane.this.myHelpButton.setBounds(x -= spacing + buttonWidth, (h - buttonHeight) / 2, buttonWidth, buttonHeight);
        }
    }

    private class SystemMenuBar
    extends JMenuBar {
        private SystemMenuBar() {
        }

        @Override
        public void paint(Graphics g) {
            if (this.isOpaque()) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (DarculaTitlePane.this.mySystemIcon != null) {
                int offset = (this.getHeight() - DarculaTitlePane.this.mySystemIcon.getHeight(null)) / 2;
                g.drawImage(DarculaTitlePane.this.mySystemIcon, offset, offset, null);
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, g, 0, 0);
                }
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(16, size.width), Math.max(size.height, 16));
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(UIManager.getString((Object)"DarculaTitlePane.maximizeTitle", DarculaTitlePane.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DarculaTitlePane.this.maximize();
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(UIManager.getString((Object)"DarculaTitlePane.restoreTitle", DarculaTitlePane.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DarculaTitlePane.this.restore();
        }
    }

    private class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(UIManager.getString((Object)"DarculaTitlePane.iconifyTitle", DarculaTitlePane.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DarculaTitlePane.this.iconify();
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(UIManager.getString((Object)"DarculaTitlePane.closeTitle", DarculaTitlePane.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DarculaTitlePane.this.close();
        }
    }
}

