/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.psi.PsiClass;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class FQNameCellRenderer
extends SimpleColoredComponent
implements ListCellRenderer {
    private final Font FONT;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.FQNameCellRenderer");

    public FQNameCellRenderer() {
        EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        this.FONT = new Font(scheme2.getEditorFontName(), 0, scheme2.getEditorFontSize());
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
        this.clear();
        if (value2 instanceof PsiClass) {
            PsiClass aClass = (PsiClass)value2;
            this.setIcon(aClass.getIcon(0));
            if (aClass.getQualifiedName() != null) {
                SimpleTextAttributes attributes = aClass.isDeprecated() ? new SimpleTextAttributes(4, null) : SimpleTextAttributes.REGULAR_ATTRIBUTES;
                this.append(aClass.getQualifiedName(), attributes);
            }
        } else {
            LOG.assertTrue(value2 instanceof String);
            String qName = (String)value2;
            this.append(qName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.setIcon(AllIcons.Nodes.Static);
        }
        this.setFont(this.FONT);
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        return this;
    }
}

