/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.ide.util.SuperMethodWarningDialog;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.searches.DeepestSuperMethodsSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class SuperMethodWarningUtil {
    private SuperMethodWarningUtil() {
    }

    @NotNull
    public static PsiMethod[] checkSuperMethods(@NotNull PsiMethod method2, @NotNull String actionString) {
        return SuperMethodWarningUtil.checkSuperMethods(method2, actionString, Collections.emptyList());
    }

    @NotNull
    public static PsiMethod[] checkSuperMethods(@NotNull PsiMethod method2, @NotNull String actionString, @NotNull Collection<PsiElement> ignore) {
        PsiClass aClass = method2.getContainingClass();
        if (aClass == null) {
            return new PsiMethod[]{method2};
        }
        Collection<PsiMethod> superMethods = SuperMethodWarningUtil.getSuperMethods(method2, aClass, ignore);
        if (superMethods.isEmpty()) {
            return new PsiMethod[]{method2};
        }
        HashSet<String> superClasses = new HashSet<String>();
        boolean superAbstract = false;
        boolean parentInterface = false;
        for (PsiMethod superMethod : superMethods) {
            PsiClass containingClass = superMethod.getContainingClass();
            superClasses.add(containingClass.getQualifiedName());
            boolean isInterface = containingClass.isInterface();
            superAbstract |= isInterface || superMethod.hasModifierProperty("abstract");
            parentInterface |= isInterface;
        }
        SuperMethodWarningDialog dialog2 = new SuperMethodWarningDialog(method2.getProject(), DescriptiveNameUtil.getDescriptiveName((PsiElement)method2), actionString, superAbstract, parentInterface, aClass.isInterface(), ArrayUtil.toStringArray(superClasses));
        dialog2.show();
        if (dialog2.getExitCode() == 0) {
            return superMethods.toArray(new PsiMethod[superMethods.size()]);
        }
        if (dialog2.getExitCode() == 3) {
            return new PsiMethod[]{method2};
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    static Collection<PsiMethod> getSuperMethods(@NotNull PsiMethod method2, PsiClass aClass, @NotNull Collection<PsiElement> ignore) {
        PsiMethod siblingSuperMethod;
        VirtualFile virtualFile;
        Collection superMethods = DeepestSuperMethodsSearch.search((PsiMethod)method2).findAll();
        superMethods.removeAll(ignore);
        if (superMethods.isEmpty() && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)aClass)) != null && ProjectRootManager.getInstance((Project)aClass.getProject()).getFileIndex().isInSourceContent(virtualFile) && (siblingSuperMethod = FindSuperElementsHelper.getSiblingInheritedViaSubClass(method2)) != null) {
            superMethods.add(siblingSuperMethod);
        }
        return superMethods;
    }

    public static PsiMethod checkSuperMethod(@NotNull PsiMethod method2, @NotNull String actionString) {
        PsiClass aClass = method2.getContainingClass();
        if (aClass == null) {
            return method2;
        }
        PsiMethod superMethod = method2.findDeepestSuperMethod();
        if (superMethod == null) {
            return method2;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return superMethod;
        }
        PsiClass containingClass = superMethod.getContainingClass();
        SuperMethodWarningDialog dialog2 = new SuperMethodWarningDialog(method2.getProject(), DescriptiveNameUtil.getDescriptiveName((PsiElement)method2), actionString, containingClass.isInterface() || superMethod.hasModifierProperty("abstract"), containingClass.isInterface(), aClass.isInterface(), containingClass.getQualifiedName());
        dialog2.show();
        if (dialog2.getExitCode() == 0) {
            return superMethod;
        }
        if (dialog2.getExitCode() == 3) {
            return method2;
        }
        return null;
    }

    public static void checkSuperMethod(@NotNull PsiMethod method2, @NotNull String actionString, @NotNull PsiElementProcessor<PsiMethod> processor2, @NotNull Editor editor) {
        PsiClass aClass = method2.getContainingClass();
        if (aClass == null) {
            processor2.execute((PsiElement)method2);
            return;
        }
        PsiMethod superMethod = method2.findDeepestSuperMethod();
        if (superMethod == null) {
            processor2.execute((PsiElement)method2);
            return;
        }
        PsiClass containingClass = superMethod.getContainingClass();
        if (containingClass == null) {
            processor2.execute((PsiElement)method2);
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            processor2.execute((PsiElement)superMethod);
            return;
        }
        PsiMethod[] methods = new PsiMethod[]{superMethod, method2};
        String renameBase = actionString + " base method";
        String renameCurrent = actionString + " only current method";
        JBList list = new JBList(new Object[]{renameBase, renameCurrent});
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle(method2.getName() + (containingClass.isInterface() && !aClass.isInterface() ? " implements" : " overrides") + " method of " + SymbolPresentationUtil.getSymbolPresentableText((PsiElement)containingClass)).setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> {
            Object value2 = list.getSelectedValue();
            if (value2 instanceof String) {
                processor2.execute((PsiElement)methods[value2.equals(renameBase) ? 0 : 1]);
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    @Messages.YesNoCancelResult
    public static int askWhetherShouldAnnotateBaseMethod(@NotNull PsiMethod method2, @NotNull PsiMethod superMethod) {
        String implement = !method2.hasModifierProperty("abstract") && superMethod.hasModifierProperty("abstract") ? InspectionsBundle.message((String)"inspection.annotate.quickfix.implements", (Object[])new Object[0]) : InspectionsBundle.message((String)"inspection.annotate.quickfix.overrides", (Object[])new Object[0]);
        String message2 = InspectionsBundle.message((String)"inspection.annotate.quickfix.overridden.method.messages", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)method2), implement, DescriptiveNameUtil.getDescriptiveName((PsiElement)superMethod)});
        String title = InspectionsBundle.message((String)"inspection.annotate.quickfix.overridden.method.warning", (Object[])new Object[0]);
        return Messages.showYesNoCancelDialog((Project)method2.getProject(), (String)message2, (String)title, (Icon)Messages.getQuestionIcon());
    }
}

