/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.frameworkSupport;

import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportProvider;
import com.intellij.ide.util.newProjectWizard.OldFrameworkSupportProviderWrapper;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.util.Couple;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameworkSupportUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.frameworkSupport.FrameworkSupportUtil");

    private FrameworkSupportUtil() {
    }

    public static List<FrameworkSupportInModuleProvider> getProviders(@NotNull ModuleType moduleType, @NotNull FacetsProvider facetsProvider) {
        return FrameworkSupportUtil.getProviders(moduleType, null, facetsProvider);
    }

    public static List<FrameworkSupportInModuleProvider> getProviders(@NotNull Module module2, @NotNull FacetsProvider facetsProvider) {
        return FrameworkSupportUtil.getProviders(ModuleType.get((Module)module2), module2, facetsProvider);
    }

    private static List<FrameworkSupportInModuleProvider> getProviders(@NotNull ModuleType moduleType, @Nullable Module module2, @NotNull FacetsProvider facetsProvider) {
        List<FrameworkSupportInModuleProvider> allProviders = FrameworkSupportUtil.getAllProviders();
        ArrayList<FrameworkSupportInModuleProvider> result2 = new ArrayList<FrameworkSupportInModuleProvider>();
        for (FrameworkSupportInModuleProvider provider2 : allProviders) {
            if (!provider2.isEnabledForModuleType(moduleType) || module2 != null && !provider2.canAddSupport(module2, facetsProvider)) continue;
            result2.add(provider2);
        }
        return result2;
    }

    public static List<FrameworkSupportInModuleProvider> getAllProviders() {
        ArrayList<FrameworkSupportInModuleProvider> allTypes = new ArrayList<FrameworkSupportInModuleProvider>();
        for (FrameworkSupportProvider frameworkSupportProvider : (FrameworkSupportProvider[])FrameworkSupportProvider.EXTENSION_POINT.getExtensions()) {
            allTypes.add(new OldFrameworkSupportProviderWrapper(frameworkSupportProvider));
        }
        for (FrameworkTypeEx frameworkTypeEx : (FrameworkTypeEx[])FrameworkTypeEx.EP_NAME.getExtensions()) {
            allTypes.add(frameworkTypeEx.createProvider());
        }
        return allTypes;
    }

    public static List<FrameworkSupportInModuleProvider> getProviders(@NotNull ModuleBuilder builder) {
        ArrayList<FrameworkSupportInModuleProvider> result2 = new ArrayList<FrameworkSupportInModuleProvider>();
        for (FrameworkSupportInModuleProvider type2 : FrameworkSupportUtil.getAllProviders()) {
            if (!type2.isEnabledForModuleBuilder(builder)) continue;
            result2.add(type2);
        }
        return result2;
    }

    public static boolean hasProviders(Module module2, @NotNull FacetsProvider facetsProvider) {
        List<FrameworkSupportInModuleProvider> providers = FrameworkSupportUtil.getProviders(module2, facetsProvider);
        for (FrameworkSupportInModuleProvider provider2 : providers) {
            if (provider2.getFrameworkType().getUnderlyingFrameworkTypeId() != null) continue;
            return true;
        }
        return false;
    }

    public static Comparator<FrameworkSupportInModuleProvider> getFrameworkSupportProvidersComparator(List<FrameworkSupportInModuleProvider> types) {
        DFSTBuilder builder = new DFSTBuilder(GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new ProvidersGraph(types))));
        if (!builder.isAcyclic()) {
            Couple pair = builder.getCircularDependency();
            LOG.error("Circular dependency between types '" + ((FrameworkSupportInModuleProvider)pair.getFirst()).getFrameworkType().getId() + "' and '" + ((FrameworkSupportInModuleProvider)pair.getSecond()).getFrameworkType().getId() + "' was found.");
        }
        return builder.comparator();
    }

    public static FrameworkSupportInModuleProvider findProvider(@NotNull String id) {
        return FrameworkSupportUtil.findProvider(id, FrameworkSupportUtil.getAllProviders());
    }

    @Nullable
    public static FrameworkSupportInModuleProvider findProvider(@NotNull String id, List<FrameworkSupportInModuleProvider> providers) {
        for (FrameworkSupportInModuleProvider provider2 : providers) {
            String frameworkId = provider2.getFrameworkType().getId();
            if (!id.equals(frameworkId) && !id.equals("facet:" + frameworkId)) continue;
            return provider2;
        }
        LOG.info("Cannot find framework support provider '" + id + "'");
        return null;
    }

    private static class ProvidersGraph
    implements InboundSemiGraph<FrameworkSupportInModuleProvider> {
        private final List<FrameworkSupportInModuleProvider> myFrameworkSupportProviders;

        public ProvidersGraph(List<FrameworkSupportInModuleProvider> frameworkSupportProviders) {
            this.myFrameworkSupportProviders = new ArrayList<FrameworkSupportInModuleProvider>(frameworkSupportProviders);
        }

        public Collection<FrameworkSupportInModuleProvider> getNodes() {
            return this.myFrameworkSupportProviders;
        }

        public Iterator<FrameworkSupportInModuleProvider> getIn(FrameworkSupportInModuleProvider provider2) {
            Object underlyingProvider;
            ArrayList<Object> dependencies = new ArrayList<Object>();
            String underlyingId = provider2.getFrameworkType().getUnderlyingFrameworkTypeId();
            if (underlyingId != null && (underlyingProvider = FrameworkSupportUtil.findProvider(underlyingId, this.myFrameworkSupportProviders)) != null) {
                dependencies.add(underlyingProvider);
            }
            for (FrameworkSupportInModuleProvider.FrameworkDependency frameworkId : provider2.getDependenciesFrameworkIds()) {
                FrameworkSupportInModuleProvider dep = FrameworkSupportUtil.findProvider(frameworkId.getFrameworkId(), this.myFrameworkSupportProviders);
                if (dep == null) continue;
                dependencies.add(dep);
            }
            if (provider2 instanceof OldFrameworkSupportProviderWrapper) {
                String[] ids;
                for (String id : ids = ((OldFrameworkSupportProviderWrapper)provider2).getProvider().getPrecedingFrameworkProviderIds()) {
                    FrameworkSupportInModuleProvider dependency = FrameworkSupportUtil.findProvider(id, this.myFrameworkSupportProviders);
                    if (dependency == null) continue;
                    dependencies.add(dependency);
                }
            }
            return dependencies.iterator();
        }
    }
}

