/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.frameworkSupport;

import com.intellij.facet.impl.ui.libraries.RequiredLibrariesInfo;
import com.intellij.facet.ui.libraries.LibraryDownloadInfo;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.framework.FrameworkAvailabilityCondition;
import com.intellij.framework.library.DownloadableLibraryDescription;
import com.intellij.framework.library.DownloadableLibraryFileDescription;
import com.intellij.framework.library.FrameworkLibraryVersion;
import com.intellij.framework.library.impl.DownloadableLibraryDescriptionImpl;
import com.intellij.framework.library.impl.DownloadableLibraryFileDescriptionImpl;
import com.intellij.framework.library.impl.FrameworkLibraryVersionImpl;
import com.intellij.ide.util.frameworkSupport.CustomLibraryDescriptionBase;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OldCustomLibraryDescription
extends CustomLibraryDescriptionBase {
    private final DownloadableLibraryDescription myDownloadableDescription;
    private final List<FrameworkVersion> myVersions;

    public OldCustomLibraryDescription(@NotNull LibraryInfo[] libraryInfos, @NotNull String defaultLibraryName) {
        this(Collections.singletonList(new FrameworkVersion(defaultLibraryName, defaultLibraryName, libraryInfos, true)), defaultLibraryName);
    }

    private OldCustomLibraryDescription(List<FrameworkVersion> versions, String defaultLibraryName) {
        super(defaultLibraryName);
        this.myVersions = versions;
        ArrayList<FrameworkLibraryVersion> libraryVersions = new ArrayList<FrameworkLibraryVersion>();
        for (FrameworkVersion version : versions) {
            ArrayList<DownloadableLibraryFileDescription> downloads = new ArrayList<DownloadableLibraryFileDescription>();
            for (LibraryInfo info : version.getLibraries()) {
                LibraryDownloadInfo downloadingInfo = info.getDownloadingInfo();
                if (downloadingInfo == null) continue;
                downloads.add(new DownloadableLibraryFileDescriptionImpl(downloadingInfo.getDownloadUrl(), downloadingInfo.getFileNamePrefix(), downloadingInfo.getFileNameSuffix(), null, null, false));
            }
            String libraryName = version.getLibraryName();
            libraryVersions.add(new FrameworkLibraryVersionImpl(libraryName, version.getVersionName(), FrameworkAvailabilityCondition.ALWAYS_TRUE, downloads, libraryName));
        }
        this.myDownloadableDescription = !libraryVersions.isEmpty() ? new DownloadableLibraryDescriptionImpl(libraryVersions) : null;
    }

    public DownloadableLibraryDescription getDownloadableDescription() {
        return this.myDownloadableDescription;
    }

    public boolean isSuitableLibrary(@NotNull Library library, @NotNull LibrariesContainer container) {
        for (FrameworkVersion version : this.myVersions) {
            RequiredLibrariesInfo info = new RequiredLibrariesInfo(version.getLibraries());
            if (info.checkLibraries(container.getLibraryFiles(library, OrderRootType.CLASSES)) != null) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Set<? extends LibraryKind> getSuitableLibraryKinds() {
        return Collections.emptySet();
    }

    @Nullable
    public static CustomLibraryDescription createByVersions(List<? extends FrameworkVersion> versions) {
        String defaultLibraryName = null;
        ArrayList<FrameworkVersion> withLibraries = new ArrayList<FrameworkVersion>();
        for (FrameworkVersion frameworkVersion : versions) {
            if (frameworkVersion.getLibraries().length <= 0) continue;
            if (frameworkVersion.isDefault()) {
                defaultLibraryName = frameworkVersion.getLibraryName();
            }
            withLibraries.add(frameworkVersion);
        }
        if (withLibraries.isEmpty()) {
            return null;
        }
        if (defaultLibraryName == null) {
            defaultLibraryName = ((FrameworkVersion)withLibraries.get(0)).getLibraryName();
        }
        return new OldCustomLibraryDescription(withLibraries, defaultLibraryName);
    }
}

