/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class DefaultFileNavigationContributor
implements ChooseByNameContributorEx,
DumbAware {
    @NotNull
    public String[] getNames(Project project2, boolean includeNonProjectItems) {
        if (FileBasedIndex.ourEnableTracingOfKeyHashToVirtualFileMapping) {
            THashSet names = new THashSet(1000);
            IdFilter filter = IdFilter.getProjectIdFilter((Project)project2, (boolean)includeNonProjectItems);
            this.processNames((Processor<String>)((Processor)s -> {
                names.add(s);
                return true;
            }), FindSymbolParameters.searchScopeFor(project2, includeNonProjectItems), filter);
            if (IdFilter.LOG.isDebugEnabled()) {
                IdFilter.LOG.debug("All names retrieved2:" + names.size());
            }
            return ArrayUtil.toStringArray((Collection)names);
        }
        return FilenameIndex.getAllFilenames(project2);
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name, String pattern, Project project2, boolean includeNonProjectItems) {
        ArrayList result2 = new ArrayList();
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        this.processElementsWithName(name, (Processor<NavigationItem>)processor2, FindSymbolParameters.wrap(pattern, project2, includeNonProjectItems));
        return result2.isEmpty() ? NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY : result2.toArray(new NavigationItem[result2.size()]);
    }

    @Override
    public void processNames(@NotNull Processor<String> processor2, @NotNull GlobalSearchScope scope, IdFilter filter) {
        long started = System.currentTimeMillis();
        FilenameIndex.processAllFileNames(processor2, scope, filter);
        if (IdFilter.LOG.isDebugEnabled()) {
            IdFilter.LOG.debug("All names retrieved:" + (System.currentTimeMillis() - started));
        }
    }

    @Override
    public void processElementsWithName(@NotNull String name, @NotNull Processor<NavigationItem> _processor, @NotNull FindSymbolParameters parameters2) {
        boolean globalSearch = parameters2.getSearchScope().isSearchInLibraries();
        Processor processor2 = item -> {
            if (!globalSearch && ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)item.getVirtualFile())) {
                return true;
            }
            return _processor.process(item);
        };
        String completePattern = parameters2.getCompletePattern();
        boolean includeDirs = completePattern.endsWith("/") || completePattern.endsWith("\\") || completePattern.startsWith("/") || completePattern.startsWith("\\");
        boolean result2 = FilenameIndex.processFilesByName(name, includeDirs, (Processor<? super PsiFileSystemItem>)processor2, parameters2.getSearchScope(), parameters2.getProject(), parameters2.getIdFilter());
        if (!result2 && includeDirs) {
            FilenameIndex.processFilesByName(name, false, (Processor<? super PsiFileSystemItem>)processor2, parameters2.getSearchScope(), parameters2.getProject(), parameters2.getIdFilter());
        }
    }
}

