/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.navigation.ChooseByNameContributorEx;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.FindSymbolParameters;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultSymbolNavigationContributor
implements ChooseByNameContributorEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.gotoByName.DefaultSymbolNavigationContributor");

    @NotNull
    public String[] getNames(Project project2, boolean includeNonProjectItems) {
        PsiShortNamesCache cache2 = PsiShortNamesCache.getInstance((Project)project2);
        HashSet set2 = new HashSet();
        cache2.getAllMethodNames(set2);
        cache2.getAllFieldNames(set2);
        cache2.getAllClassNames(set2);
        return ArrayUtil.toStringArray((Collection)set2);
    }

    @NotNull
    public NavigationItem[] getItemsByName(String name, String pattern, Project project2, boolean includeNonProjectItems) {
        GlobalSearchScope scope = includeNonProjectItems ? GlobalSearchScope.allScope((Project)project2) : GlobalSearchScope.projectScope((Project)project2);
        PsiShortNamesCache cache2 = PsiShortNamesCache.getInstance((Project)project2);
        Condition<PsiMember> qualifiedMatcher = DefaultSymbolNavigationContributor.getQualifiedNameMatcher(pattern);
        ArrayList<PsiMethod> result2 = new ArrayList<PsiMethod>();
        for (PsiMethod psiMethod : cache2.getMethodsByName(name, scope)) {
            if (psiMethod.isConstructor() || !DefaultSymbolNavigationContributor.isOpenable((PsiMember)psiMethod) || DefaultSymbolNavigationContributor.hasSuperMethod(psiMethod, scope, qualifiedMatcher)) continue;
            result2.add(psiMethod);
        }
        for (PsiMethod psiMethod : cache2.getFieldsByName(name, scope)) {
            if (!DefaultSymbolNavigationContributor.isOpenable((PsiMember)psiMethod)) continue;
            result2.add(psiMethod);
        }
        for (PsiMethod psiMethod : cache2.getClassesByName(name, scope)) {
            if (!DefaultSymbolNavigationContributor.isOpenable((PsiMember)psiMethod)) continue;
            result2.add(psiMethod);
        }
        PsiMember[] array = result2.toArray(new PsiMember[result2.size()]);
        Arrays.sort(array, MyComparator.INSTANCE);
        return array;
    }

    private static boolean isOpenable(PsiMember member) {
        PsiFile file2 = member.getContainingFile();
        return file2 != null && file2.getVirtualFile() != null;
    }

    private static boolean hasSuperMethodCandidates(PsiMethod method2, GlobalSearchScope scope, Condition<PsiMember> qualifiedMatcher) {
        if (method2.hasModifierProperty("private") || method2.hasModifierProperty("static")) {
            return false;
        }
        PsiClass containingClass = method2.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        int parametersCount = method2.getParameterList().getParametersCount();
        return !InheritanceUtil.processSupers((PsiClass)containingClass, (boolean)false, superClass -> {
            if (PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope, (PsiElement)superClass)) {
                for (PsiMethod candidate : superClass.findMethodsByName(method2.getName(), false)) {
                    if (parametersCount != candidate.getParameterList().getParametersCount() || candidate.hasModifierProperty("private") || candidate.hasModifierProperty("static") || !qualifiedMatcher.value((Object)candidate)) continue;
                    return false;
                }
            }
            return true;
        });
    }

    private static boolean hasSuperMethod(PsiMethod method2, GlobalSearchScope scope, Condition<PsiMember> qualifiedMatcher) {
        if (!DefaultSymbolNavigationContributor.hasSuperMethodCandidates(method2, scope, qualifiedMatcher)) {
            return false;
        }
        for (HierarchicalMethodSignature signature : method2.getHierarchicalMethodSignature().getSuperSignatures()) {
            PsiMethod superMethod = signature.getMethod();
            if (!PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope, (PsiElement)superMethod) || !qualifiedMatcher.value((Object)superMethod)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void processNames(@NotNull Processor<String> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        PsiShortNamesCache cache2 = PsiShortNamesCache.getInstance((Project)scope.getProject());
        cache2.processAllClassNames(processor2, scope, filter);
        cache2.processAllFieldNames(processor2, scope, filter);
        cache2.processAllMethodNames(processor2, scope, filter);
    }

    @Override
    public void processElementsWithName(@NotNull String name, @NotNull Processor<NavigationItem> processor2, @NotNull FindSymbolParameters parameters2) {
        boolean success;
        GlobalSearchScope scope = parameters2.getSearchScope();
        IdFilter filter = parameters2.getIdFilter();
        PsiShortNamesCache cache2 = PsiShortNamesCache.getInstance((Project)scope.getProject());
        String completePattern = parameters2.getCompletePattern();
        Condition<PsiMember> qualifiedMatcher = DefaultSymbolNavigationContributor.getQualifiedNameMatcher(completePattern);
        THashSet collectedMethods = new THashSet();
        boolean bl = success = cache2.processFieldsWithName(name, field -> {
            if (DefaultSymbolNavigationContributor.isOpenable((PsiMember)field) && qualifiedMatcher.value(field)) {
                return processor2.process(field);
            }
            return true;
        }, scope, filter) && cache2.processClassesWithName(name, aClass -> {
            if (DefaultSymbolNavigationContributor.isOpenable((PsiMember)aClass) && qualifiedMatcher.value(aClass)) {
                return processor2.process(aClass);
            }
            return true;
        }, scope, filter) && cache2.processMethodsWithName(name, arg_0 -> DefaultSymbolNavigationContributor.lambda$processElementsWithName$3(qualifiedMatcher, (Set)collectedMethods, arg_0), scope, filter);
        if (success) {
            Iterator iterator = collectedMethods.iterator();
            while (iterator.hasNext()) {
                PsiMethod method2 = (PsiMethod)iterator.next();
                if (!DefaultSymbolNavigationContributor.hasSuperMethod(method2, scope, qualifiedMatcher) && !processor2.process((Object)method2)) {
                    return;
                }
                ProgressManager.checkCanceled();
                iterator.remove();
            }
        }
    }

    private static Condition<PsiMember> getQualifiedNameMatcher(String completePattern) {
        Condition qualifiedMatcher;
        if (completePattern.contains(".")) {
            MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + StringUtil.replace((String)completePattern, (String)".", (String)".*"))).build();
            qualifiedMatcher = member -> {
                String qualifiedName = PsiUtil.getMemberQualifiedName((PsiMember)member);
                return qualifiedName != null && matcher.matches(qualifiedName);
            };
        } else {
            qualifiedMatcher = Condition.TRUE;
        }
        return qualifiedMatcher;
    }

    private static /* synthetic */ boolean lambda$processElementsWithName$3(Condition qualifiedMatcher, Set collectedMethods, PsiMethod method2) {
        if (!method2.isConstructor() && DefaultSymbolNavigationContributor.isOpenable((PsiMember)method2) && qualifiedMatcher.value((Object)method2)) {
            collectedMethods.add(method2);
        }
        return true;
    }

    private static class MyComparator
    implements Comparator<PsiModifierListOwner> {
        public static final MyComparator INSTANCE = new MyComparator();
        private final DefaultPsiElementCellRenderer myRenderer = new DefaultPsiElementCellRenderer();

        private MyComparator() {
        }

        @Override
        public int compare(PsiModifierListOwner element1, PsiModifierListOwner element2) {
            String text2;
            String text1;
            int kind2;
            int level2;
            if (element1 == element2) {
                return 0;
            }
            PsiModifierList modifierList1 = element1.getModifierList();
            PsiModifierList modifierList2 = element2.getModifierList();
            int level1 = modifierList1 == null ? 4 : PsiUtil.getAccessLevel((PsiModifierList)modifierList1);
            int n = level2 = modifierList2 == null ? 4 : PsiUtil.getAccessLevel((PsiModifierList)modifierList2);
            if (level1 != level2) {
                return level2 - level1;
            }
            int kind1 = MyComparator.getElementTypeLevel((PsiElement)element1);
            if (kind1 != (kind2 = MyComparator.getElementTypeLevel((PsiElement)element2))) {
                return kind1 - kind2;
            }
            if (element1 instanceof PsiMethod) {
                LOG.assertTrue(element2 instanceof PsiMethod);
                PsiParameter[] params1 = ((PsiMethod)element1).getParameterList().getParameters();
                PsiParameter[] params2 = ((PsiMethod)element2).getParameterList().getParameters();
                if (params1.length != params2.length) {
                    return params1.length - params2.length;
                }
            }
            if (!(text1 = this.myRenderer.getElementText((PsiElement)element1)).equals(text2 = this.myRenderer.getElementText((PsiElement)element2))) {
                return text1.compareTo(text2);
            }
            String containerText1 = this.myRenderer.getContainerText((PsiElement)element1, text1);
            String containerText2 = this.myRenderer.getContainerText((PsiElement)element2, text2);
            if (containerText1 == null) {
                containerText1 = "";
            }
            if (containerText2 == null) {
                containerText2 = "";
            }
            return containerText1.compareTo(containerText2);
        }

        private static int getElementTypeLevel(PsiElement element) {
            if (element instanceof PsiMethod) {
                return 1;
            }
            if (element instanceof PsiField) {
                return 2;
            }
            if (element instanceof PsiClass) {
                return 3;
            }
            LOG.error((Object)element);
            return 0;
        }
    }
}

