/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.DataManager;
import com.intellij.ide.SearchTopHitProvider;
import com.intellij.ide.actions.ApplyIntentionAction;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.search.ActionFromOptionDescriptorProvider;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.ide.ui.search.SearchableOptionsRegistrarImpl;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.GotoActionModel;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoActionItemProvider
implements ChooseByNameItemProvider {
    private final ActionManager myActionManager = ActionManager.getInstance();
    private final GotoActionModel myModel;
    private final NotNullLazyValue<Map<String, ApplyIntentionAction>> myIntentions;

    public GotoActionItemProvider(GotoActionModel model) {
        this.myModel = model;
        this.myIntentions = NotNullLazyValue.createValue(() -> this.myModel.getAvailableIntentions());
    }

    @Override
    @NotNull
    public List<String> filterNames(@NotNull ChooseByNameBase base, @NotNull String[] names, @NotNull String pattern) {
        return Collections.emptyList();
    }

    @Override
    public boolean filterElements(@NotNull ChooseByNameBase base, @NotNull String pattern, boolean everywhere, @NotNull ProgressIndicator cancelled, @NotNull Processor<Object> consumer2) {
        return this.filterElements(pattern, everywhere, (Processor<GotoActionModel.MatchedValue>)((Processor)arg_0 -> consumer2.process(arg_0)));
    }

    public boolean filterElements(String pattern, boolean everywhere, Processor<GotoActionModel.MatchedValue> consumer2) {
        DataContext dataContext = DataManager.getInstance().getDataContext(this.myModel.getContextComponent());
        if (!this.processAbbreviations(pattern, consumer2, dataContext)) {
            return false;
        }
        if (!this.processIntentions(pattern, consumer2, dataContext)) {
            return false;
        }
        if (!this.processActions(pattern, everywhere, consumer2, dataContext)) {
            return false;
        }
        if (!GotoActionItemProvider.processTopHits(pattern, consumer2, dataContext)) {
            return false;
        }
        return this.processOptions(pattern, consumer2, dataContext);
    }

    private boolean processAbbreviations(String pattern, Processor<GotoActionModel.MatchedValue> consumer2, DataContext context) {
        List actionIds = AbbreviationManager.getInstance().findActions(pattern);
        JBIterable wrappers = JBIterable.from((Iterable)actionIds).transform(arg_0 -> ((ActionManager)this.myActionManager).getAction(arg_0)).filter(Condition.NOT_NULL).transform(action -> {
            GotoActionModel.ActionWrapper wrapper = new GotoActionModel.ActionWrapper((AnAction)action, this.myModel.myActionGroups.get(action), GotoActionModel.MatchMode.NAME, context);
            return new GotoActionModel.MatchedValue(wrapper, pattern){

                @Override
                @Nullable
                public String getValueText() {
                    return this.pattern;
                }
            };
        });
        return GotoActionItemProvider.processItems(pattern, (JBIterable<? extends Comparable>)wrappers, consumer2);
    }

    private static boolean processTopHits(String pattern, Processor<GotoActionModel.MatchedValue> consumer2, DataContext dataContext) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        CollectConsumer collector = new CollectConsumer();
        for (SearchTopHitProvider provider2 : (SearchTopHitProvider[])SearchTopHitProvider.EP_NAME.getExtensions()) {
            if (provider2 instanceof OptionsTopHitProvider.CoveredByToggleActions || provider2 instanceof OptionsTopHitProvider && !((OptionsTopHitProvider)provider2).isEnabled(project2)) continue;
            if (provider2 instanceof OptionsTopHitProvider && !StringUtil.startsWith((CharSequence)pattern, (CharSequence)"#")) {
                String prefix = "#" + ((OptionsTopHitProvider)provider2).getId() + " ";
                provider2.consumeTopHits(prefix + pattern, (Consumer)collector, project2);
            }
            provider2.consumeTopHits(pattern, (Consumer)collector, project2);
        }
        Collection result2 = collector.getResult();
        return GotoActionItemProvider.processItems(pattern, (JBIterable<? extends Comparable>)JBIterable.from((Iterable)result2).filter(Comparable.class), consumer2);
    }

    private boolean processOptions(String pattern, Processor<GotoActionModel.MatchedValue> consumer2, DataContext dataContext) {
        this.myModel.initConfigurables();
        SearchableOptionsRegistrarImpl registrar = (SearchableOptionsRegistrarImpl)SearchableOptionsRegistrar.getInstance();
        ArrayList options = ContainerUtil.newArrayList();
        Set<String> words = registrar.getProcessedWords(pattern);
        Set<OptionDescription> optionDescriptions = null;
        String actionManagerName = this.myActionManager.getComponentName();
        for (String word : words) {
            Set<OptionDescription> descriptions = registrar.getAcceptableDescriptions(word);
            if (descriptions != null) {
                Iterator<OptionDescription> iterator = descriptions.iterator();
                while (iterator.hasNext()) {
                    OptionDescription description = iterator.next();
                    if (!actionManagerName.equals(description.getPath())) continue;
                    iterator.remove();
                }
                if (descriptions.isEmpty()) continue;
                if (optionDescriptions == null) {
                    optionDescriptions = descriptions;
                    continue;
                }
                optionDescriptions.retainAll(descriptions);
                continue;
            }
            optionDescriptions = null;
            break;
        }
        if (optionDescriptions != null && !optionDescriptions.isEmpty()) {
            HashSet<String> currentHits = new HashSet<String>();
            Iterator iterator = optionDescriptions.iterator();
            while (iterator.hasNext()) {
                OptionDescription description = (OptionDescription)iterator.next();
                String hit = description.getHit();
                if (hit != null && currentHits.add(hit.trim())) continue;
                iterator.remove();
            }
            for (OptionDescription description : optionDescriptions) {
                for (ActionFromOptionDescriptorProvider converter : (ActionFromOptionDescriptorProvider[])ActionFromOptionDescriptorProvider.EP.getExtensions()) {
                    AnAction action = converter.provide(description);
                    if (action != null) {
                        options.add(new GotoActionModel.ActionWrapper(action, null, GotoActionModel.MatchMode.NAME, dataContext));
                    }
                    options.add(description);
                }
            }
        }
        return GotoActionItemProvider.processItems(pattern, (JBIterable<? extends Comparable>)JBIterable.from((Iterable)options), consumer2);
    }

    private boolean processActions(String pattern, boolean everywhere, Processor<GotoActionModel.MatchedValue> consumer2, DataContext dataContext) {
        JBIterable actions;
        if (everywhere) {
            Set<String> ids = ((ActionManagerImpl)this.myActionManager).getActionIds();
            actions = JBIterable.from(ids).transform(arg_0 -> ((ActionManager)this.myActionManager).getAction(arg_0)).filter(Condition.NOT_NULL);
        } else {
            actions = JBIterable.from(this.myModel.myActionGroups.keySet());
        }
        MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + pattern), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
        JBIterable actionWrappers = actions.transform(action -> {
            GotoActionModel.MatchMode mode = this.myModel.actionMatches(pattern, matcher, (AnAction)action);
            if (mode == GotoActionModel.MatchMode.NONE) {
                return null;
            }
            return new GotoActionModel.ActionWrapper((AnAction)action, this.myModel.myActionGroups.get(action), mode, dataContext);
        }).filter(Condition.NOT_NULL);
        return GotoActionItemProvider.processItems(pattern, (JBIterable<? extends Comparable>)actionWrappers, consumer2);
    }

    private boolean processIntentions(String pattern, Processor<GotoActionModel.MatchedValue> consumer2, DataContext dataContext) {
        MinusculeMatcher matcher = NameUtil.buildMatcher((String)("*" + pattern), (NameUtil.MatchingCaseSensitivity)NameUtil.MatchingCaseSensitivity.NONE);
        Map intentionMap = (Map)this.myIntentions.getValue();
        JBIterable intentions = JBIterable.from(intentionMap.keySet()).transform(intentionText -> {
            ApplyIntentionAction intentionAction = (ApplyIntentionAction)((Object)((Object)intentionMap.get(intentionText)));
            if (this.myModel.actionMatches(pattern, matcher, intentionAction) == GotoActionModel.MatchMode.NONE) {
                return null;
            }
            return new GotoActionModel.ActionWrapper(intentionAction, (String)intentionText, GotoActionModel.MatchMode.INTENTION, dataContext);
        }).filter(Condition.NOT_NULL);
        return GotoActionItemProvider.processItems(pattern, (JBIterable<? extends Comparable>)intentions, consumer2);
    }

    private static boolean processItems(String pattern, JBIterable<? extends Comparable> items, Processor<GotoActionModel.MatchedValue> consumer2) {
        ArrayList matched = ContainerUtil.newArrayList();
        items.transform(o -> {
            ProgressManager.checkCanceled();
            return o instanceof GotoActionModel.MatchedValue ? (GotoActionModel.MatchedValue)o : new GotoActionModel.MatchedValue((Comparable)o, pattern);
        }).addAllTo((Collection)matched);
        Collections.sort(matched);
        return ContainerUtil.process((List)matched, consumer2);
    }
}

