/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.ide.util.gotoByName.ChooseByNameItem;
import com.intellij.ide.util.gotoByName.SimpleChooseByNameModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListChooseByNameModel<T extends ChooseByNameItem>
extends SimpleChooseByNameModel {
    private static final int MAX_DESC_LENGTH = 80;
    private static final String ELLIPSIS_SUFFIX = "...";
    private Pattern myCompiledPattern;
    private String myPattern;
    private final List<T> myItems;
    private final String myNotInMessage;

    public ListChooseByNameModel(@NotNull Project project2, String prompt, String notInMessage, List<T> items) {
        super(project2, prompt, null);
        this.myItems = items;
        this.myNotInMessage = notInMessage;
    }

    @Override
    public String[] getNames() {
        ArrayList<String> taskFullCmds = new ArrayList<String>();
        for (ChooseByNameItem item : this.myItems) {
            taskFullCmds.add(item.getName());
        }
        return ArrayUtil.toStringArray(taskFullCmds);
    }

    @Override
    protected Object[] getElementsByName(String name, String pattern) {
        for (ChooseByNameItem item : this.myItems) {
            if (!item.getName().equals(name)) continue;
            return new Object[]{item};
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public String getNotInMessage() {
        return this.myNotInMessage;
    }

    @Override
    public String getNotFoundMessage() {
        return this.myNotInMessage;
    }

    public ListCellRenderer getListCellRenderer() {
        return new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel panel2 = new JPanel(new BorderLayout());
                panel2.setOpaque(true);
                panel2.setBorder((Border)JBUI.Borders.emptyRight((int)5));
                Color bg = isSelected ? UIUtil.getListSelectionBackground() : UIUtil.getListBackground();
                panel2.setBackground(bg);
                if (value2 instanceof ChooseByNameItem) {
                    ChooseByNameItem item = (ChooseByNameItem)value2;
                    Color fg = isSelected ? UIUtil.getListSelectionForeground() : UIUtil.getListForeground();
                    JLabel actionLabel = new JLabel(item.getName(), null, 2);
                    actionLabel.setBackground(bg);
                    actionLabel.setForeground(fg);
                    actionLabel.setFont(actionLabel.getFont().deriveFont(1));
                    actionLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)4));
                    panel2.add((Component)actionLabel, "West");
                    String description = item.getDescription();
                    if (description != null) {
                        String normalizedDesc = description.length() > 80 ? description.substring(0, 80) + ListChooseByNameModel.ELLIPSIS_SUFFIX : description;
                        JLabel descriptionLabel = new JLabel(normalizedDesc);
                        descriptionLabel.setBackground(bg);
                        descriptionLabel.setForeground(fg);
                        descriptionLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)15));
                        panel2.add((Component)descriptionLabel, "East");
                    }
                } else {
                    JLabel actionLabel = new JLabel(value2.toString(), null, 2);
                    actionLabel.setBackground(bg);
                    actionLabel.setForeground(UIUtil.getListForeground());
                    actionLabel.setFont(actionLabel.getFont().deriveFont(0));
                    actionLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)4));
                    panel2.add((Component)actionLabel, "West");
                }
                return panel2;
            }
        };
    }

    public String getElementName(Object element) {
        if (!(element instanceof ChooseByNameItem)) {
            return null;
        }
        return ((ChooseByNameItem)element).getName();
    }

    public boolean matches(@NotNull String name, @NotNull String pattern) {
        Pattern compiledPattern = this.getTaskPattern(pattern);
        if (compiledPattern == null) {
            return false;
        }
        return new Perl5Matcher().matches(name, compiledPattern);
    }

    @Nullable
    private Pattern getTaskPattern(String pattern) {
        if (!Comparing.strEqual((String)pattern, (String)this.myPattern)) {
            this.myCompiledPattern = null;
            this.myPattern = pattern;
        }
        if (this.myCompiledPattern == null) {
            String regex = "^.*" + NameUtil.buildRegexp((String)pattern, (int)0, (boolean)true, (boolean)true);
            Perl5Compiler compiler = new Perl5Compiler();
            try {
                this.myCompiledPattern = compiler.compile(regex);
            }
            catch (MalformedPatternException malformedPatternException) {
                // empty catch block
            }
        }
        return this.myCompiledPattern;
    }
}

