/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.framework.FrameworkOrGroup;
import com.intellij.ide.util.newProjectWizard.FrameworkGroupNode;
import com.intellij.ui.CheckedTreeNode;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkSupportNodeBase<T extends FrameworkOrGroup>
extends CheckedTreeNode {
    private final FrameworkSupportNodeBase myParentNode;

    public FrameworkSupportNodeBase(T userObject, FrameworkSupportNodeBase parentNode) {
        super(userObject);
        this.setChecked(false);
        this.myParentNode = parentNode;
        if (parentNode != null) {
            parentNode.add((MutableTreeNode)((Object)this));
        }
    }

    public T getUserObject() {
        return (T)((FrameworkOrGroup)super.getUserObject());
    }

    public static void sortByName(@Nullable List<FrameworkSupportNodeBase> nodes, @Nullable Comparator<FrameworkSupportNodeBase> comparator2) {
        if (nodes == null) {
            return;
        }
        Collections.sort(nodes, (o1, o2) -> {
            int compare;
            if (comparator2 != null && (compare = comparator2.compare((FrameworkSupportNodeBase)((Object)o1), (FrameworkSupportNodeBase)((Object)o2))) != 0) {
                return compare;
            }
            if (o1 instanceof FrameworkGroupNode && !(o2 instanceof FrameworkGroupNode)) {
                return -1;
            }
            if (o2 instanceof FrameworkGroupNode && !(o1 instanceof FrameworkGroupNode)) {
                return 1;
            }
            if (o1.getChildCount() < o2.getChildCount()) {
                return 1;
            }
            if (o1.getChildCount() > o2.getChildCount()) {
                return -1;
            }
            return o1.getTitle().compareToIgnoreCase(o2.getTitle());
        });
        for (FrameworkSupportNodeBase node : nodes) {
            FrameworkSupportNodeBase.sortByName(node.children, null);
        }
    }

    @NotNull
    protected final String getTitle() {
        return this.getUserObject().getPresentableName();
    }

    @NotNull
    public final Icon getIcon() {
        return this.getUserObject().getIcon();
    }

    @NotNull
    public final String getId() {
        return this.getUserObject().getId();
    }

    @NotNull
    public List<FrameworkSupportNodeBase> getChildren() {
        return this.children != null ? this.children : Collections.emptyList();
    }

    public FrameworkSupportNodeBase getParentNode() {
        return this.myParentNode;
    }
}

