/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.util.newProjectWizard.LoadingProjectTemplate;
import com.intellij.ide.util.newProjectWizard.SelectTemplateSettings;
import com.intellij.ide.util.newProjectWizard.TemplatesGroup;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.templates.RemoteTemplatesFactory;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.containers.MultiMap;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectTypesList
implements Disposable {
    private final JBList myList;
    private final CollectionListModel<TemplateItem> myModel;
    private MinusculeMatcher myMatcher;
    private Pair<TemplateItem, Integer> myBestMatch;
    private TemplateItem myLoadingItem;

    public ProjectTypesList(JBList list, MultiMap<TemplatesGroup, ProjectTemplate> map2, final WizardContext context) {
        this.myList = list;
        new ListSpeedSearch((JList)this.myList){

            @Override
            protected String getElementText(Object element) {
                return super.getElementText(element);
            }
        }.setComparator(new SpeedSearchComparator(false));
        List<TemplateItem> items = this.buildItems(map2);
        TemplatesGroup samplesGroup = new TemplatesGroup("Loading Templates...", "", null, 0, null, null, null);
        this.myLoadingItem = new TemplateItem(new LoadingProjectTemplate(), samplesGroup){

            @Override
            Icon getIcon() {
                return null;
            }

            @Override
            String getDescription() {
                return "";
            }
        };
        items.add(this.myLoadingItem);
        this.myModel = new CollectionListModel(items);
        final RemoteTemplatesFactory factory = new RemoteTemplatesFactory();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(context.getProject(), "Loading Templates"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    ProjectTypesList.this.myList.setPaintBusy(true);
                    String[] groups = factory.getGroups();
                    ArrayList<TemplateItem> items = new ArrayList<TemplateItem>();
                    for (String group : groups) {
                        ProjectTemplate[] templates;
                        TemplatesGroup templatesGroup = new TemplatesGroup(group, "", factory.getGroupIcon(group), 0, null, null, null);
                        for (ProjectTemplate template : templates = factory.createTemplates(group, context)) {
                            items.add(new TemplateItem(template, templatesGroup));
                        }
                    }
                    SwingUtilities.invokeLater(() -> {
                        int index = ProjectTypesList.this.myList.getSelectedIndex();
                        ProjectTypesList.this.myModel.remove((Object)ProjectTypesList.this.myLoadingItem);
                        ProjectTypesList.this.myModel.add(items);
                        ProjectTypesList.this.myList.setSelectedIndex(index);
                    });
                }
                finally {
                    ProjectTypesList.this.myList.setPaintBusy(false);
                }
            }
        });
        this.myList.setCellRenderer(new GroupedItemsListRenderer(new ListItemDescriptorAdapter(){

            @Nullable
            public String getTextFor(Object value2) {
                return ((TemplateItem)value2).getName();
            }

            @Nullable
            public Icon getIconFor(Object value2) {
                return ((TemplateItem)value2).getIcon();
            }

            public boolean hasSeparatorAboveOf(Object value2) {
                TemplateItem item = (TemplateItem)value2;
                int index = ProjectTypesList.this.myModel.getElementIndex((Object)item);
                return index == 0 || !((TemplateItem)ProjectTypesList.this.myModel.getElementAt(index - 1)).getGroupName().equals(item.getGroupName());
            }

            @Nullable
            public String getCaptionAboveOf(Object value2) {
                return ((TemplateItem)value2).getGroupName();
            }
        }));
        this.myList.setModel(this.myModel);
    }

    void installKeyAction(JComponent component) {
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                InputEvent event = e.getInputEvent();
                if (event instanceof KeyEvent) {
                    int row = ProjectTypesList.this.myList.getSelectedIndex();
                    switch (((KeyEvent)event).getKeyCode()) {
                        case 38: {
                            int toSelect = row == 0 ? ProjectTypesList.this.myList.getItemsCount() - 1 : row - 1;
                            ProjectTypesList.this.myList.setSelectedIndex(toSelect);
                            ProjectTypesList.this.myList.ensureIndexIsVisible(toSelect);
                            break;
                        }
                        case 40: {
                            int toSelect = row < ProjectTypesList.this.myList.getItemsCount() - 1 ? row + 1 : 0;
                            ProjectTypesList.this.myList.setSelectedIndex(toSelect);
                            ProjectTypesList.this.myList.ensureIndexIsVisible(toSelect);
                        }
                    }
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Integer[]{38, 40}), component);
    }

    void resetSelection() {
        if (this.myList.getSelectedIndex() != -1) {
            return;
        }
        SelectTemplateSettings settings = SelectTemplateSettings.getInstance();
        if (settings.getLastGroup() == null || !this.setSelectedTemplate(settings.getLastGroup(), settings.getLastTemplate())) {
            this.myList.setSelectedIndex(0);
        }
    }

    void saveSelection() {
        TemplateItem item = (TemplateItem)this.myList.getSelectedValue();
        if (item != null) {
            SelectTemplateSettings.getInstance().setLastTemplate(item.getGroupName(), item.getName());
        }
    }

    private List<TemplateItem> buildItems(MultiMap<TemplatesGroup, ProjectTemplate> map2) {
        ArrayList<TemplateItem> items = new ArrayList<TemplateItem>();
        ArrayList groups = new ArrayList(map2.keySet());
        Collections.sort(groups);
        for (TemplatesGroup group : groups) {
            for (ProjectTemplate template : map2.get((Object)group)) {
                TemplateItem templateItem = new TemplateItem(template, group);
                items.add(templateItem);
            }
        }
        return items;
    }

    @Nullable
    public ProjectTemplate getSelectedTemplate() {
        Object value2 = this.myList.getSelectedValue();
        return value2 instanceof TemplateItem ? ((TemplateItem)value2).myTemplate : null;
    }

    public boolean setSelectedTemplate(@Nullable String group, @Nullable String name) {
        for (int i2 = 0; i2 < this.myList.getModel().getSize(); ++i2) {
            Object o = this.myList.getModel().getElementAt(i2);
            if (!(o instanceof TemplateItem) || !((TemplateItem)o).myGroup.getName().equals(group) || !((TemplateItem)o).getName().equals(name)) continue;
            this.myList.setSelectedIndex(i2);
            this.myList.ensureIndexIsVisible(i2);
            return true;
        }
        return false;
    }

    public void dispose() {
    }

    class TemplateItem {
        private final ProjectTemplate myTemplate;
        private final TemplatesGroup myGroup;

        TemplateItem(ProjectTemplate template, TemplatesGroup group) {
            this.myTemplate = template;
            this.myGroup = group;
        }

        String getName() {
            return this.myTemplate.getName();
        }

        public String getGroupName() {
            return this.myGroup.getName();
        }

        Icon getIcon() {
            return this.myTemplate.createModuleBuilder().getNodeIcon();
        }

        protected int getMatchingDegree() {
            if (ProjectTypesList.this.myMatcher == null) {
                return Integer.MAX_VALUE;
            }
            String text = this.getName() + " " + this.getGroupName();
            String description = this.getDescription();
            if (description != null) {
                text = text + " " + StringUtil.stripHtml((String)description, (boolean)false);
            }
            int i2 = ProjectTypesList.this.myMatcher.matchingDegree(text);
            if (ProjectTypesList.this.myBestMatch == null || i2 > (Integer)((ProjectTypesList)ProjectTypesList.this).myBestMatch.second) {
                ProjectTypesList.this.myBestMatch = Pair.create((Object)this, (Object)i2);
            }
            return i2;
        }

        @Nullable
        String getDescription() {
            return this.myTemplate.getDescription();
        }

        public String toString() {
            return this.getName() + " " + this.getGroupName();
        }
    }
}

