/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.util.projectWizard.AbstractModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StepSequence {
    private final List<ModuleWizardStep> myCommonSteps = new ArrayList<ModuleWizardStep>();
    private final List<Pair<ModuleWizardStep, Set<String>>> myCommonFinishingSteps = new ArrayList<Pair<ModuleWizardStep, Set<String>>>();
    private final MultiMap<String, ModuleWizardStep> mySpecificSteps = new MultiMap();
    @NonNls
    private List<String> myTypes = new ArrayList<String>();
    private List<ModuleWizardStep> mySelectedSteps;

    public StepSequence(ModuleWizardStep ... commonSteps) {
        this.myCommonSteps.addAll(Arrays.asList(commonSteps));
    }

    public void addCommonStep(@NotNull ModuleWizardStep step) {
        this.myCommonSteps.add(step);
    }

    public void addCommonFinishingStep(@NotNull ModuleWizardStep step, @Nullable Set<String> suitableTypes) {
        this.myCommonFinishingSteps.add((Pair<ModuleWizardStep, Set<String>>)Pair.create((Object)step, suitableTypes));
    }

    public void addStepsForBuilder(@NotNull AbstractModuleBuilder builder, @NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        String id = builder.getBuilderId();
        if (!this.mySpecificSteps.containsKey((Object)id)) {
            this.mySpecificSteps.put((Object)id, Arrays.asList(builder.createWizardSteps(wizardContext, modulesProvider)));
        }
    }

    public void addSpecificStep(String type2, ModuleWizardStep step) {
        this.mySpecificSteps.putValue((Object)type2, (Object)step);
    }

    public List<ModuleWizardStep> getSelectedSteps() {
        if (this.mySelectedSteps == null) {
            this.mySelectedSteps = new ArrayList<ModuleWizardStep>();
            this.mySelectedSteps.addAll(this.myCommonSteps);
            for (String string : this.myTypes) {
                Collection steps = this.mySpecificSteps.get((Object)string);
                this.mySelectedSteps.addAll(steps);
            }
            for (Pair pair : this.myCommonFinishingSteps) {
                Set types = (Set)pair.getSecond();
                if (types != null && !ContainerUtil.intersects(this.myTypes, (Collection)types)) continue;
                this.mySelectedSteps.add((ModuleWizardStep)pair.getFirst());
            }
            ContainerUtil.removeDuplicates(this.mySelectedSteps);
        }
        return this.mySelectedSteps;
    }

    @Nullable
    public ModuleWizardStep getNextStep(ModuleWizardStep step) {
        List<ModuleWizardStep> steps = this.getSelectedSteps();
        int i2 = steps.indexOf(step);
        return i2 < steps.size() - 1 ? steps.get(i2 + 1) : null;
    }

    @Nullable
    public ModuleWizardStep getPreviousStep(ModuleWizardStep step) {
        List<ModuleWizardStep> steps = this.getSelectedSteps();
        int i2 = steps.indexOf(step);
        return i2 > 0 ? steps.get(i2 - 1) : null;
    }

    public void setTypes(Collection<String> types) {
        this.myTypes.clear();
        this.myTypes.addAll(types);
        this.mySelectedSteps = null;
    }

    public void setType(@Nullable @NonNls String type2) {
        this.setTypes(Collections.singletonList(type2 == null ? ModuleType.EMPTY.getId() : type2));
    }

    public String getSelectedType() {
        return (String)ContainerUtil.getFirstItem(this.myTypes);
    }

    public List<ModuleWizardStep> getAllSteps() {
        ArrayList<ModuleWizardStep> result2 = new ArrayList<ModuleWizardStep>();
        result2.addAll(this.myCommonSteps);
        result2.addAll(this.mySpecificSteps.values());
        for (Pair<ModuleWizardStep, Set<String>> pair : this.myCommonFinishingSteps) {
            result2.add((ModuleWizardStep)pair.getFirst());
        }
        ContainerUtil.removeDuplicates(result2);
        return result2;
    }
}

