/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard.modes;

import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.newProjectWizard.modes.WizardMode;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.projectImport.ImportChooserStep;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectImportProvider;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportMode
extends WizardMode {
    private ProjectImportBuilder myBuilder;
    private final ProjectImportProvider[] myProviders;

    public ImportMode() {
        this((ProjectImportProvider[])Extensions.getExtensions(ProjectImportProvider.PROJECT_IMPORT_PROVIDER));
    }

    public ImportMode(ProjectImportProvider[] providers) {
        this.myProviders = providers;
    }

    @Override
    @NotNull
    public String getDisplayName(WizardContext context) {
        return ProjectBundle.message((String)"project.new.wizard.import.title", (Object[])new Object[]{context.getPresentationName()});
    }

    @Override
    @NotNull
    public String getDescription(WizardContext context) {
        String productName = ApplicationNamesInfo.getInstance().getFullProductName();
        return ProjectBundle.message((String)"project.new.wizard.import.description", (Object[])new Object[]{productName, context.getPresentationName(), StringUtil.join(Arrays.asList(Extensions.getExtensions(ProjectImportProvider.PROJECT_IMPORT_PROVIDER)), provider2 -> provider2.getName(), (String)", ")});
    }

    @Override
    @Nullable
    protected StepSequence createSteps(@NotNull WizardContext context, @NotNull ModulesProvider modulesProvider) {
        StepSequence stepSequence = new StepSequence(new ModuleWizardStep[0]);
        if (this.myProviders.length > 1) {
            stepSequence.addCommonStep(new ImportChooserStep(this.myProviders, stepSequence, context));
        }
        for (ProjectImportProvider provider2 : this.myProviders) {
            provider2.addSteps(stepSequence, context, provider2.getId());
        }
        if (this.myProviders.length == 1) {
            stepSequence.setType(this.myProviders[0].getId());
        }
        return stepSequence;
    }

    @Override
    public boolean isAvailable(WizardContext context) {
        return ((ProjectImportProvider[])Extensions.getExtensions(ProjectImportProvider.PROJECT_IMPORT_PROVIDER)).length > 0;
    }

    @Override
    @Nullable
    public ProjectBuilder getModuleBuilder() {
        return this.myBuilder;
    }

    @Override
    public void onChosen(boolean enabled) {
    }

    @Override
    public String getShortName() {
        return "Import from External Model";
    }
}

