/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.SourcePathsStep;
import com.intellij.ide.util.newProjectWizard.SupportForFrameworksStep;
import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.JavaSettingsStep;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.ProjectJdkForModuleStep;
import com.intellij.ide.util.projectWizard.ProjectJdkStep;
import com.intellij.ide.util.projectWizard.ProjectNameStep;
import com.intellij.ide.util.projectWizard.ProjectWizardStepFactory;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainerFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectWizardStepFactoryImpl
extends ProjectWizardStepFactory {
    private static final Key<ProjectJdkStep> PROJECT_JDK_STEP_KEY = Key.create((String)"ProjectJdkStep");

    public ModuleWizardStep createNameAndLocationStep(WizardContext wizardContext) {
        return new ProjectNameStep(wizardContext);
    }

    public ModuleWizardStep createSourcePathsStep(ModuleWizardStep nameAndLocationStep, SourcePathsBuilder builder, Icon icon, String helpId) {
        return null;
    }

    public ModuleWizardStep createSourcePathsStep(WizardContext context, SourcePathsBuilder builder, Icon icon, @NonNls String helpId) {
        return new SourcePathsStep(builder, icon, helpId);
    }

    public ModuleWizardStep createProjectJdkStep(WizardContext context, JavaModuleBuilder builder, Computable<Boolean> isVisible, Icon icon, String helpId) {
        return this.createProjectJdkStep(context, null, builder, isVisible, icon, helpId);
    }

    public ModuleWizardStep createProjectJdkStep(WizardContext context, SdkType type2, final JavaModuleBuilder builder, final Computable<Boolean> isVisible, final Icon icon, final @NonNls String helpId) {
        return new ProjectJdkForModuleStep(context, type2){

            @Override
            public void updateDataModel() {
                super.updateDataModel();
                builder.setModuleJdk(this.getJdk());
            }

            public boolean isStepVisible() {
                return (Boolean)isVisible.compute();
            }

            @Override
            public Icon getIcon() {
                return icon;
            }

            public String getName() {
                return "Specify JDK";
            }

            @Override
            public String getHelpId() {
                return helpId;
            }
        };
    }

    public ModuleWizardStep createProjectJdkStep(final WizardContext wizardContext) {
        ProjectJdkStep projectSdkStep = (ProjectJdkStep)((Object)wizardContext.getUserData(PROJECT_JDK_STEP_KEY));
        if (projectSdkStep != null) {
            return projectSdkStep;
        }
        projectSdkStep = new ProjectJdkStep(wizardContext){

            public boolean isStepVisible() {
                Sdk newProjectJdk = AbstractProjectWizard.getProjectSdkByDefault(wizardContext);
                if (newProjectJdk == null) {
                    return true;
                }
                ProjectBuilder projectBuilder = wizardContext.getProjectBuilder();
                return projectBuilder != null && !projectBuilder.isSuitableSdk(newProjectJdk);
            }
        };
        wizardContext.putUserData(PROJECT_JDK_STEP_KEY, (Object)projectSdkStep);
        return projectSdkStep;
    }

    @Nullable
    public Sdk getNewProjectSdk(WizardContext wizardContext) {
        return AbstractProjectWizard.getNewProjectJdk(wizardContext);
    }

    public ModuleWizardStep createSupportForFrameworksStep(WizardContext wizardContext, ModuleBuilder moduleBuilder) {
        return this.createSupportForFrameworksStep(wizardContext, moduleBuilder, ModulesProvider.EMPTY_MODULES_PROVIDER);
    }

    public ModuleWizardStep createSupportForFrameworksStep(@NotNull WizardContext context, @NotNull ModuleBuilder builder, @NotNull ModulesProvider modulesProvider) {
        LibrariesContainer container = LibrariesContainerFactory.createContainer(context, modulesProvider);
        return new SupportForFrameworksStep(context, builder, container);
    }

    public ModuleWizardStep createJavaSettingsStep(@NotNull SettingsStep settingsStep, @NotNull ModuleBuilder moduleBuilder, @NotNull Condition<SdkTypeId> sdkFilter) {
        return new JavaSettingsStep(settingsStep, moduleBuilder, sdkFilter);
    }
}

