/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard.importSources;

import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.ide.util.projectWizard.importSources.util.CommonSourceRootDetectionUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.NullableFunction;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class JavaSourceRootDetector
extends ProjectStructureDetector {
    @Override
    @NotNull
    public ProjectStructureDetector.DirectoryProcessingResult detectRoots(@NotNull File dir, @NotNull File[] children2, @NotNull File base, @NotNull List<DetectedProjectRoot> result2) {
        if (dir.getName().equals("node_modules")) {
            return ProjectStructureDetector.DirectoryProcessingResult.SKIP_CHILDREN;
        }
        String fileExtension = this.getFileExtension();
        if ("java".equals(fileExtension)) {
            for (File child : children2) {
                if (!child.isFile() || !"module-info.java".equals(child.getName())) continue;
                JavaModuleSourceRoot sourceRoot = new JavaModuleSourceRoot(dir, this.getLanguageName(), true);
                result2.add(sourceRoot);
                return ProjectStructureDetector.DirectoryProcessingResult.SKIP_CHILDREN;
            }
        }
        for (File child : children2) {
            if (!child.isFile() || !FileUtilRt.extensionEquals((String)child.getName(), (String)fileExtension)) continue;
            Pair<File, String> root = CommonSourceRootDetectionUtil.IO_FILE.suggestRootForFileWithPackageStatement(child, base, this.getPackageNameFetcher(), true);
            if (root != null) {
                JavaModuleSourceRoot sourceRoot = new JavaModuleSourceRoot((File)root.getFirst(), (String)root.getSecond(), this.getLanguageName());
                result2.add(sourceRoot);
                if (JavaSourceRootDetector.areLastRootsTheSame(result2, sourceRoot, 20)) {
                    return ProjectStructureDetector.DirectoryProcessingResult.skipChildrenAndParentsUpTo((File)root.getFirst());
                }
            }
            return ProjectStructureDetector.DirectoryProcessingResult.SKIP_CHILDREN;
        }
        return ProjectStructureDetector.DirectoryProcessingResult.PROCESS_CHILDREN;
    }

    private static boolean areLastRootsTheSame(List<DetectedProjectRoot> result2, JavaModuleSourceRoot root, int threshold) {
        if (result2.size() < threshold) {
            return false;
        }
        List<DetectedProjectRoot> lastItems = result2.subList(result2.size() - threshold, result2.size());
        for (DetectedProjectRoot item : lastItems) {
            if (!(item instanceof JavaModuleSourceRoot)) {
                return false;
            }
            JavaModuleSourceRoot oldRoot = (JavaModuleSourceRoot)item;
            if (FileUtil.filesEqual((File)oldRoot.getDirectory(), (File)root.getDirectory()) && oldRoot.getPackagePrefix().equals(root.getPackagePrefix()) && oldRoot.getRootTypeName().equals(root.getRootTypeName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getDetectorId() {
        return "Java";
    }

    @NotNull
    protected abstract String getLanguageName();

    @NotNull
    protected abstract String getFileExtension();

    @NotNull
    protected abstract NullableFunction<CharSequence, String> getPackageNameFetcher();
}

