/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.ide.structureView.impl.StructureViewElementWrapper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.smartTree.Filter;
import com.intellij.ide.util.treeView.smartTree.Group;
import com.intellij.ide.util.treeView.smartTree.GroupWrapper;
import com.intellij.ide.util.treeView.smartTree.Grouper;
import com.intellij.ide.util.treeView.smartTree.Sorter;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElementWrapper;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class CachingChildrenTreeNode<Value>
extends AbstractTreeNode<Value> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.treeView.smartTree.CachingChildrenTreeNode");
    private List<CachingChildrenTreeNode> myChildren;
    private List<CachingChildrenTreeNode> myOldChildren = null;
    protected final TreeModel myTreeModel;

    public CachingChildrenTreeNode(Project project2, Value value2, TreeModel treeModel) {
        super(project2, value2 instanceof StructureViewElementWrapper ? ((StructureViewElementWrapper)value2).getWrappedElement() : value2);
        this.myTreeModel = treeModel;
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        this.ensureChildrenAreInitialized();
        return new ArrayList<AbstractTreeNode>(this.myChildren);
    }

    private void ensureChildrenAreInitialized() {
        if (this.myChildren == null) {
            this.myChildren = new ArrayList<CachingChildrenTreeNode>();
            this.rebuildSubtree();
        }
    }

    protected void addSubElement(CachingChildrenTreeNode node) {
        this.ensureChildrenAreInitialized();
        this.myChildren.add(node);
        node.setParent(this);
    }

    protected void setChildren(Collection<AbstractTreeNode> children2) {
        this.clearChildren();
        for (AbstractTreeNode node : children2) {
            this.myChildren.add((CachingChildrenTreeNode)node);
            node.setParent((AbstractTreeNode)this);
        }
    }

    protected void sortChildren(Sorter[] sorters) {
        if (this.myChildren == null) {
            return;
        }
        Collections.sort(this.myChildren, new CompositeComparator(sorters));
        for (CachingChildrenTreeNode child : this.myChildren) {
            if (!(child instanceof GroupWrapper)) continue;
            child.sortChildren(sorters);
        }
    }

    protected void filterChildren(@NotNull Filter[] filters) {
        Collection<AbstractTreeNode> children2 = this.getChildren();
        for (Filter filter : filters) {
            Iterator<AbstractTreeNode> eachNode = children2.iterator();
            while (eachNode.hasNext()) {
                TreeElementWrapper eachChild = (TreeElementWrapper)eachNode.next();
                TreeElement value2 = (TreeElement)eachChild.getValue();
                if (value2 != null && filter.isVisible(value2)) continue;
                eachNode.remove();
            }
        }
        this.setChildren(children2);
    }

    protected void groupChildren(@NotNull Grouper[] groupers) {
        for (Grouper grouper : groupers) {
            this.groupElements(grouper);
        }
        Collection<AbstractTreeNode> children2 = this.getChildren();
        for (AbstractTreeNode child : children2) {
            if (!(child instanceof GroupWrapper)) continue;
            ((GroupWrapper)child).groupChildren(groupers);
        }
    }

    private void groupElements(Grouper grouper) {
        ArrayList<AbstractTreeNode<TreeElement>> ungrouped = new ArrayList<AbstractTreeNode<TreeElement>>();
        Collection<AbstractTreeNode> children2 = this.getChildren();
        for (AbstractTreeNode child : children2) {
            CachingChildrenTreeNode node = (CachingChildrenTreeNode)child;
            if (!(node instanceof TreeElementWrapper)) continue;
            ungrouped.add(node);
        }
        if (!ungrouped.isEmpty()) {
            this.processUngrouped(ungrouped, grouper);
        }
        LinkedHashSet<AbstractTreeNode> result2 = new LinkedHashSet<AbstractTreeNode>();
        for (AbstractTreeNode child : children2) {
            AbstractTreeNode parent = child.getParent();
            if (parent != this) {
                if (result2.contains(parent)) continue;
                result2.add(parent);
                continue;
            }
            result2.add(child);
        }
        this.setChildren(result2);
    }

    private void processUngrouped(@NotNull List<AbstractTreeNode<TreeElement>> ungrouped, @NotNull Grouper grouper) {
        Map<TreeElement, AbstractTreeNode> ungroupedObjects = CachingChildrenTreeNode.collectValues(ungrouped);
        Collection groups = grouper.group((AbstractTreeNode)this, ungroupedObjects.keySet());
        Map<Group, GroupWrapper> groupNodes = this.createGroupNodes(groups);
        for (Group group : groups) {
            if (group == null) {
                LOG.error(grouper + " returned null group: " + groups);
            }
            GroupWrapper groupWrapper = groupNodes.get(group);
            Collection children2 = group.getChildren();
            for (TreeElement node : children2) {
                if (node == null) {
                    LOG.error(group + " returned null child: " + children2);
                }
                TreeElementWrapper child = this.createChildNode(node);
                groupWrapper.addSubElement(child);
                AbstractTreeNode abstractTreeNode = ungroupedObjects.get(node);
                abstractTreeNode.setParent((AbstractTreeNode)groupWrapper);
            }
        }
    }

    protected TreeElementWrapper createChildNode(@NotNull TreeElement child) {
        return new TreeElementWrapper(this.getProject(), child, this.myTreeModel);
    }

    private static Map<TreeElement, AbstractTreeNode> collectValues(List<AbstractTreeNode<TreeElement>> ungrouped) {
        LinkedHashMap<TreeElement, AbstractTreeNode> objects = new LinkedHashMap<TreeElement, AbstractTreeNode>();
        for (AbstractTreeNode<TreeElement> node : ungrouped) {
            objects.put((TreeElement)node.getValue(), node);
        }
        return objects;
    }

    private Map<Group, GroupWrapper> createGroupNodes(@NotNull Collection<Group> groups) {
        THashMap result2 = new THashMap();
        for (Group group : groups) {
            result2.put(group, this.createGroupWrapper(this.getProject(), group, this.myTreeModel));
        }
        return result2;
    }

    protected GroupWrapper createGroupWrapper(Project project2, @NotNull Group group, TreeModel treeModel) {
        return new GroupWrapper(project2, group, treeModel);
    }

    private void rebuildSubtree() {
        this.initChildren();
        this.performTreeActions();
        this.synchronizeChildren();
    }

    protected void synchronizeChildren() {
        List<CachingChildrenTreeNode> children2 = this.myChildren;
        if (this.myOldChildren != null && children2 != null) {
            HashMap<CachingChildrenTreeNode, CachingChildrenTreeNode> oldValuesToChildrenMap = new HashMap<CachingChildrenTreeNode, CachingChildrenTreeNode>();
            for (CachingChildrenTreeNode oldChild : this.myOldChildren) {
                Object oldValue = oldChild instanceof TreeElementWrapper ? oldChild.getValue() : oldChild;
                if (oldValue == null) continue;
                oldValuesToChildrenMap.put((CachingChildrenTreeNode)((Object)oldValue), oldChild);
            }
            for (int i2 = 0; i2 < children2.size(); ++i2) {
                CachingChildrenTreeNode oldChild;
                Object newValue;
                CachingChildrenTreeNode newChild = children2.get(i2);
                Object object = newValue = newChild instanceof TreeElementWrapper ? newChild.getValue() : newChild;
                if (newValue == null || (oldChild = (CachingChildrenTreeNode)((Object)oldValuesToChildrenMap.get(newValue))) == null) continue;
                oldChild.copyFromNewInstance(newChild);
                oldChild.setValue(newChild.getValue());
                children2.set(i2, oldChild);
            }
            this.myOldChildren = null;
        }
    }

    protected abstract void copyFromNewInstance(@NotNull CachingChildrenTreeNode var1);

    protected abstract void performTreeActions();

    protected abstract void initChildren();

    public void navigate(boolean requestFocus) {
        ((Navigatable)this.getValue()).navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.getValue() instanceof Navigatable && ((Navigatable)this.getValue()).canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.getValue() instanceof Navigatable && ((Navigatable)this.getValue()).canNavigateToSource();
    }

    protected void clearChildren() {
        if (this.myChildren != null) {
            this.myChildren.clear();
        } else {
            this.myChildren = new ArrayList<CachingChildrenTreeNode>();
        }
    }

    public void rebuildChildren() {
        if (this.myChildren != null) {
            this.myOldChildren = this.myChildren;
            for (CachingChildrenTreeNode node : this.myChildren) {
                node.rebuildChildren();
            }
            this.myChildren = null;
        }
    }

    protected void resetChildren() {
        this.myChildren = null;
    }

    private static class CompositeComparator
    implements Comparator<CachingChildrenTreeNode> {
        private final Sorter[] mySorters;

        public CompositeComparator(Sorter[] sorters) {
            this.mySorters = sorters;
        }

        @Override
        public int compare(CachingChildrenTreeNode o1, CachingChildrenTreeNode o2) {
            Object value1 = o1.getValue();
            Object value2 = o2.getValue();
            for (Sorter sorter : this.mySorters) {
                int result2 = sorter.getComparator().compare(value1, value2);
                if (result2 == 0) continue;
                return result2;
            }
            return 0;
        }
    }
}

