/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.smartTree.CachingChildrenTreeNode;
import com.intellij.ide.util.treeView.smartTree.TreeElementWrapper;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;

public class SmartTreeStructure
extends AbstractTreeStructure {
    protected final TreeModel myModel;
    protected final Project myProject;
    private TreeElementWrapper myRootElementWrapper;

    public SmartTreeStructure(@NotNull Project project2, @NotNull TreeModel model) {
        this.myModel = model;
        this.myProject = project2;
    }

    public void commit() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
    }

    @NotNull
    public ActionCallback asyncCommit() {
        return SmartTreeStructure.asyncCommitDocuments((Project)this.myProject);
    }

    public boolean hasSomethingToCommit() {
        return PsiDocumentManager.getInstance((Project)this.myProject).hasUncommitedDocuments();
    }

    @NotNull
    public NodeDescriptor createDescriptor(Object element, NodeDescriptor parentDescriptor) {
        return (AbstractTreeNode)element;
    }

    public Object[] getChildElements(Object element) {
        return ((AbstractTreeNode)element).getChildren().toArray();
    }

    public Object getParentElement(Object element) {
        return ((AbstractTreeNode)element).getParent();
    }

    public Object getRootElement() {
        if (this.myRootElementWrapper == null) {
            this.myRootElementWrapper = this.createTree();
        }
        return this.myRootElementWrapper;
    }

    protected TreeElementWrapper createTree() {
        return new TreeElementWrapper(this.myProject, this.myModel.getRoot(), this.myModel);
    }

    public boolean isAlwaysLeaf(Object element) {
        return ((AbstractTreeNode)element).isAlwaysLeaf();
    }

    public void rebuildTree() {
        ((CachingChildrenTreeNode)((Object)this.getRootElement())).rebuildChildren();
    }
}

