/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView.smartTree;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.CachingChildrenTreeNode;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.ide.util.treeView.smartTree.ProvidingTreeModel;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TreeElementWrapper
extends CachingChildrenTreeNode<TreeElement> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.util.treeView.smartTree.TreeElementWrapper");

    public TreeElementWrapper(Project project2, TreeElement value2, TreeModel treeModel) {
        super(project2, value2, treeModel);
    }

    @Override
    public void copyFromNewInstance(@NotNull CachingChildrenTreeNode oldInstance) {
    }

    public void update(PresentationData presentation) {
        if (((StructureViewTreeElement)this.getValue()).getValue() != null) {
            presentation.updateFrom(((TreeElement)this.getValue()).getPresentation());
        }
    }

    @Override
    public void initChildren() {
        Object[] children2;
        this.clearChildren();
        TreeElement value2 = (TreeElement)this.getValue();
        for (TreeElement treeElement : children2 = value2.getChildren()) {
            if (treeElement == null) {
                LOG.error(value2 + " returned null child: " + Arrays.toString(children2));
            }
            this.addSubElement(this.createChildNode(treeElement));
        }
        if (this.myTreeModel instanceof ProvidingTreeModel) {
            Collection providers = ((ProvidingTreeModel)this.myTreeModel).getNodeProviders();
            for (NodeProvider provider2 : providers) {
                if (!((ProvidingTreeModel)this.myTreeModel).isEnabled(provider2)) continue;
                Collection collection = provider2.provideNodes(value2);
                for (TreeElement node : collection) {
                    if (node == null) {
                        LOG.error(provider2 + " returned null node: " + collection);
                    }
                    this.addSubElement(this.createChildNode(node));
                }
            }
        }
    }

    @Override
    protected void performTreeActions() {
        this.filterChildren(this.myTreeModel.getFilters());
        this.groupChildren(this.myTreeModel.getGroupers());
        this.sortChildren(this.myTreeModel.getSorters());
    }
}

