/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.diagnostic.LogMessageEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.ApplicationInfoProvider;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.DebugUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.apache.log4j.DefaultThrowableRenderer;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.ThrowableRenderer;
import org.apache.log4j.spi.ThrowableRendererSupport;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdeaLogger
extends Log4jBasedLogger {
    private static ApplicationInfoProvider ourApplicationInfoProvider = IdeaLogger.getIdeaInfoProvider();
    public static String ourLastActionId = "";
    public static Exception ourErrorsOccurred;
    private static final String ourCompilationTimestamp;
    @NonNls
    private static final String COMPILATION_TIMESTAMP_RESOURCE_NAME = "/.compilation-timestamp";
    private static final ThrowableRenderer ourThrowableRenderer;

    public static String getOurCompilationTimestamp() {
        return ourCompilationTimestamp;
    }

    IdeaLogger(@NotNull Logger logger) {
        super(logger);
        LoggerRepository repository = this.myLogger.getLoggerRepository();
        if (repository instanceof ThrowableRendererSupport) {
            ((ThrowableRendererSupport)repository).setThrowableRenderer(ourThrowableRenderer);
        }
    }

    public void error(Object message2) {
        if (message2 instanceof IdeaLoggingEvent) {
            this.myLogger.error(message2);
        } else {
            super.error(message2);
        }
    }

    public void error(@NonNls String message2, Attachment ... attachments) {
        this.myLogger.error((Object)LogMessageEx.createEvent(message2, DebugUtil.currentStackTrace(), attachments));
    }

    public void error(String message2, @Nullable Throwable t, String ... details) {
        if (t instanceof ControlFlowException) {
            this.myLogger.error((Object)message2, new Throwable("Control-flow exceptions (like " + t.getClass().getSimpleName() + ") should never be logged", t));
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        String detailString = StringUtil.join((String[])details, (String)"\n");
        if (ourErrorsOccurred == null) {
            String s = message2 != null && !message2.isEmpty() ? "Error message is '" + message2 + "'" : "";
            String mess = "Logger errors occurred. See IDEA logs for details. " + s;
            ourErrorsOccurred = new Exception(mess + (!detailString.isEmpty() ? "\nDetails: " + detailString : ""), t);
        }
        this.myLogger.error((Object)(message2 + (!detailString.isEmpty() ? "\nDetails: " + detailString : "")), t);
        this.logErrorHeader();
    }

    private void logErrorHeader() {
        String info = ourApplicationInfoProvider.getInfo();
        if (info != null) {
            this.myLogger.error((Object)info);
        }
        if (ourCompilationTimestamp != null) {
            this.myLogger.error((Object)("Internal version. Compiled " + ourCompilationTimestamp));
        }
        this.myLogger.error((Object)("JDK: " + System.getProperties().getProperty("java.version", "unknown")));
        this.myLogger.error((Object)("VM: " + System.getProperties().getProperty("java.vm.name", "unknown")));
        this.myLogger.error((Object)("Vendor: " + System.getProperties().getProperty("java.vendor", "unknown")));
        this.myLogger.error((Object)("OS: " + System.getProperties().getProperty("os.name", "unknown")));
        ApplicationImpl application = (ApplicationImpl)ApplicationManager.getApplication();
        if (application != null && application.isComponentsCreated() && !application.isDisposed()) {
            String currentCommandName;
            CommandProcessor commandProcessor;
            String lastPreformedActionId = ourLastActionId;
            if (lastPreformedActionId != null) {
                this.myLogger.error((Object)("Last Action: " + lastPreformedActionId));
            }
            if ((commandProcessor = CommandProcessor.getInstance()) != null && (currentCommandName = commandProcessor.getCurrentCommandName()) != null) {
                this.myLogger.error((Object)("Current Command: " + currentCommandName));
            }
        }
    }

    @NotNull
    public static ThrowableRenderer getThrowableRenderer() {
        return ourThrowableRenderer;
    }

    public static void setApplicationInfoProvider(@NotNull ApplicationInfoProvider aProvider) {
        ourApplicationInfoProvider = aProvider;
    }

    @NotNull
    private static ApplicationInfoProvider getIdeaInfoProvider() {
        return () -> {
            ApplicationInfoEx info = ApplicationInfoImpl.getShadowInstance();
            return info.getFullApplicationName() + "  Build #" + info.getBuild().asString();
        };
    }

    static {
        ourThrowableRenderer = t -> {
            int maxExtraSize;
            int maxStackSize;
            String[] defaultRes = DefaultThrowableRenderer.render((Throwable)t);
            if (defaultRes.length > (maxStackSize = 1024) + (maxExtraSize = 256)) {
                String[] res = new String[maxStackSize + maxExtraSize + 1];
                System.arraycopy(defaultRes, 0, res, 0, maxStackSize);
                res[maxStackSize] = "\t...";
                System.arraycopy(defaultRes, defaultRes.length - maxExtraSize, res, maxStackSize + 1, maxExtraSize);
                return res;
            }
            return defaultRes;
        };
        InputStream stream = com.intellij.openapi.diagnostic.Logger.class.getResourceAsStream(COMPILATION_TIMESTAMP_RESOURCE_NAME);
        String stamp = null;
        if (stream != null) {
            try (LineNumberReader reader = new LineNumberReader(new InputStreamReader(stream));){
                String s = reader.readLine();
                if (s != null) {
                    stamp = s.trim();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ourCompilationTimestamp = stamp;
    }
}

