/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indentation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.tree.TokenSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndentationFoldingBuilder
implements FoldingBuilder,
DumbAware {
    private final TokenSet myTokenSet;

    public IndentationFoldingBuilder(TokenSet tokenSet) {
        this.myTokenSet = tokenSet;
    }

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode astNode, @NotNull Document document) {
        LinkedList<FoldingDescriptor> descriptors = new LinkedList<FoldingDescriptor>();
        this.collectDescriptors(astNode, descriptors);
        return descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
    }

    private void collectDescriptors(@NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors) {
        LinkedList<ASTNode> toProcess = new LinkedList<ASTNode>();
        toProcess.add(node);
        while (!toProcess.isEmpty()) {
            ASTNode current = (ASTNode)toProcess.remove();
            if (current.getTreeParent() != null && current.getTextLength() > 1 && this.myTokenSet.contains(current.getElementType())) {
                descriptors.add(new FoldingDescriptor(current, current.getTextRange()));
            }
            for (ASTNode child = current.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                toProcess.add(child);
            }
        }
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        StringBuilder builder = new StringBuilder();
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            String text = child.getText();
            if (text == null) {
                if (builder.length() <= 0) continue;
                break;
            }
            if (!text.contains("\n")) {
                builder.append(text);
                continue;
            }
            if (builder.length() > 0) {
                builder.append(text.substring(0, text.indexOf(10)));
                break;
            }
            builder.append(IndentationFoldingBuilder.getFirstNonEmptyLine(text));
            if (builder.length() > 0) break;
        }
        return builder.toString();
    }

    @NotNull
    private static String getFirstNonEmptyLine(@NotNull String text) {
        int end;
        int start = 0;
        while ((end = text.indexOf(10, start)) != -1 && start >= end) {
            start = end + 1;
        }
        return end == -1 ? text.substring(start) : text.substring(start, end);
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        return false;
    }
}

