/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.ideSettings;

import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.StatisticsUtilKt;
import com.intellij.internal.statistic.UsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.ideSettings.IdeInitialConfigButtonUsages;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class IdeInitialConfigUsageCollectors {

    private static abstract class Base
    extends UsagesCollector {
        private Base() {
        }

        protected abstract Set<UsageDescriptor> doGetUsages() throws CollectUsagesException;

        private static boolean shouldCount() {
            return IdeInitialConfigButtonUsages.getConfigImport() != IdeInitialConfigButtonUsages.ConfigImport.NO_INIT;
        }

        @Override
        @NotNull
        public Set<UsageDescriptor> getUsages() throws CollectUsagesException {
            if (!Base.shouldCount()) {
                return Collections.emptySet();
            }
            return this.doGetUsages();
        }
    }

    public static class SelectedLAF
    extends Base {
        @Override
        protected Set<UsageDescriptor> doGetUsages() throws CollectUsagesException {
            String laf = WelcomeWizardUtil.getWizardLAF();
            if (StringUtil.isEmpty((String)laf)) {
                return Collections.emptySet();
            }
            return Collections.singleton(new UsageDescriptor(laf, 1));
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            return GroupDescriptor.create("Wizard:Selected LAF");
        }
    }

    public static class SelectedKeymap
    extends Base {
        @Override
        protected Set<UsageDescriptor> doGetUsages() throws CollectUsagesException {
            String keymapName = WelcomeWizardUtil.getWizardMacKeymap();
            if (StringUtil.isEmpty((String)keymapName)) {
                return Collections.emptySet();
            }
            return Collections.singleton(new UsageDescriptor(keymapName, 1));
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            return GroupDescriptor.create("Wizard:Selected keymap");
        }
    }

    public static class DownloadedPlugins
    extends Base {
        @Override
        @NotNull
        public Set<UsageDescriptor> doGetUsages() throws CollectUsagesException {
            return IdeInitialConfigButtonUsages.getDownloadedPlugins().stream().map(pluginId -> new UsageDescriptor((String)pluginId, 1)).collect(Collectors.toSet());
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            return GroupDescriptor.create("Wizard:Downloaded plugins");
        }
    }

    public static class DisabledPlugins
    extends Base {
        @Override
        @NotNull
        public Set<UsageDescriptor> doGetUsages() throws CollectUsagesException {
            return IdeInitialConfigButtonUsages.getPredefinedDisabledPlugins().stream().map(pluginDescriptor -> new UsageDescriptor((String)pluginDescriptor, 1)).collect(Collectors.toSet());
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            return GroupDescriptor.create("Wizard:Disabled plugins");
        }
    }

    public static class SkipSteps
    extends Base {
        @Override
        @NotNull
        public Set<UsageDescriptor> doGetUsages() throws CollectUsagesException {
            return Collections.singleton(new UsageDescriptor(IdeInitialConfigButtonUsages.getSkipRemainingPressedScreen(), 1));
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            return GroupDescriptor.create("Wizard:Skip remaining pressed");
        }
    }

    public static class ConfigImport
    extends Base {
        @Override
        @NotNull
        public Set<UsageDescriptor> doGetUsages() throws CollectUsagesException {
            return Collections.singleton(StatisticsUtilKt.getEnumUsage("import", IdeInitialConfigButtonUsages.getConfigImport()));
        }

        @Override
        @NotNull
        public GroupDescriptor getGroupId() {
            return GroupDescriptor.create("Import settings");
        }
    }
}

