/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.libraryJar;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.libraryJar.LibraryJarDescriptor;
import com.intellij.internal.statistic.libraryJar.LibraryJarStatisticsService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.containers.hash.HashSet;
import java.io.File;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryJarUsagesCollector
extends AbstractApplicationUsagesCollector {
    private static final GroupDescriptor GROUP = GroupDescriptor.create("Libraries by jars", -100.0);
    private static final String DIGIT_VERSION_PATTERN_PART = "(\\d+.\\d+|\\d+)";
    private static final Pattern JAR_FILE_NAME_PATTERN = Pattern.compile("[\\w|\\-|\\.]+-((\\d+.\\d+|\\d+)[\\w|\\.]*)jar");

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project2) throws CollectUsagesException {
        LibraryJarDescriptor[] descriptors = LibraryJarStatisticsService.getInstance().getTechnologyDescriptors();
        HashSet result2 = new HashSet(descriptors.length);
        ApplicationManager.getApplication().runReadAction(() -> LibraryJarUsagesCollector.lambda$getProjectUsages$0(descriptors, project2, (Set)result2));
        return result2;
    }

    @Nullable
    private static String getVersionByJarManifest(@NotNull VirtualFile file2) {
        return JarUtil.getJarAttribute((File)VfsUtilCore.virtualToIoFile((VirtualFile)file2), (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
    }

    @Nullable
    private static String getVersionByJarFileName(@NotNull String fileName) {
        Matcher fileNameMatcher = JAR_FILE_NAME_PATTERN.matcher(fileName);
        if (!fileNameMatcher.matches()) {
            return null;
        }
        return StringUtil.trimTrailing((String)fileNameMatcher.group(1), (char)'.');
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        return GROUP;
    }

    private static /* synthetic */ void lambda$getProjectUsages$0(LibraryJarDescriptor[] descriptors, @NotNull Project project2, Set result2) {
        for (LibraryJarDescriptor descriptor : descriptors) {
            PsiClass[] psiClasses;
            String className = descriptor.myClass;
            if (className == null) continue;
            for (PsiClass psiClass : psiClasses = JavaPsiFacade.getInstance((Project)project2).findClasses(className, ProjectScope.getLibrariesScope((Project)project2))) {
                VirtualFile jarFile;
                if (psiClass == null || (jarFile = JarFileSystem.getInstance().getLocalVirtualFileFor(psiClass.getContainingFile().getVirtualFile())) == null) continue;
                String version = LibraryJarUsagesCollector.getVersionByJarManifest(jarFile);
                if (version == null) {
                    version = LibraryJarUsagesCollector.getVersionByJarFileName(jarFile.getName());
                }
                if (version == null || !StringUtil.containsChar((String)version, (char)'.')) continue;
                result2.add(new UsageDescriptor(descriptor.myName + "_" + version, 1));
            }
        }
    }
}

