/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.persistence;

import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.persistence.CollectedUsages;
import com.intellij.openapi.project.Project;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class ApplicationStatisticsPersistence {
    private final Map<GroupDescriptor, Map<String, CollectedUsages>> myApplicationData = new THashMap();

    public void persistUsages(@NotNull GroupDescriptor groupDescriptor, @NotNull Project project2, @NotNull CollectedUsages usageDescriptors) {
        if (!this.myApplicationData.containsKey(groupDescriptor)) {
            this.myApplicationData.put(groupDescriptor, (Map<String, CollectedUsages>)new THashMap());
        }
        this.myApplicationData.get(groupDescriptor).put(project2.getName(), usageDescriptors);
    }

    @NotNull
    public Map<String, CollectedUsages> getApplicationData(@NotNull GroupDescriptor groupDescriptor) {
        if (!this.myApplicationData.containsKey(groupDescriptor)) {
            this.myApplicationData.put(groupDescriptor, (Map<String, CollectedUsages>)new THashMap());
        }
        return this.myApplicationData.get(groupDescriptor);
    }

    @NotNull
    public Map<GroupDescriptor, Map<String, CollectedUsages>> getApplicationData() {
        return this.myApplicationData;
    }
}

