/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.persistence;

import com.android.tools.analytics.AnalyticsPublisher;
import com.android.tools.analytics.AnalyticsSettings;
import com.android.tools.analytics.UsageTracker;
import com.android.utils.ILogger;
import com.intellij.concurrency.JobScheduler;
import com.intellij.internal.statistic.beans.ConvertUsagesUtil;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.configurable.SendPeriod;
import com.intellij.internal.statistic.persistence.BasicSentUsagesPersistenceComponent;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="UsagesStatistic", storages={@Storage(value="usage.statistics.xml", roamingType=RoamingType.DISABLED)})
public class UsageStatisticsPersistenceComponent
extends BasicSentUsagesPersistenceComponent
implements NamedComponent,
PersistentStateComponent<Element> {
    @NonNls
    private boolean isAllowed = false;
    @NonNls
    private boolean isShowNotification = true;
    @NotNull
    private SendPeriod myPeriod = SendPeriod.WEEKLY;
    @NonNls
    private static final String DATA_ATTR = "data";
    @NonNls
    private static final String GROUP_TAG = "group";
    @NonNls
    private static final String GROUP_ID_ATTR = "id";
    @NonNls
    private static final String GROUP_PRIORITY_ATTR = "priority";
    @NonNls
    private static final String LAST_TIME_ATTR = "time";
    @NonNls
    private static final String IS_ALLOWED_ATTR = "allowed";
    @NonNls
    private static final String PERIOD_ATTR = "period";
    @NonNls
    private static final String SHOW_NOTIFICATION_ATTR = "show-notification";

    public static UsageStatisticsPersistenceComponent getInstance() {
        return (UsageStatisticsPersistenceComponent)ApplicationManager.getApplication().getComponent(UsageStatisticsPersistenceComponent.class);
    }

    public UsageStatisticsPersistenceComponent() {
        if (ApplicationManagerEx.getApplicationEx().isInternal()) {
            this.isShowNotification = false;
        }
    }

    public void loadState(Element element) {
        for (Element groupElement : element.getChildren(GROUP_TAG)) {
            String groupId = groupElement.getAttributeValue(GROUP_ID_ATTR);
            double groupPriority = UsageStatisticsPersistenceComponent.getPriority(groupElement.getAttributeValue(GROUP_PRIORITY_ATTR));
            String valueData = groupElement.getAttributeValue(DATA_ATTR);
            if (StringUtil.isEmptyOrSpaces((String)groupId) || StringUtil.isEmptyOrSpaces((String)valueData)) continue;
            try {
                this.getSentUsages().putAll(ConvertUsagesUtil.convertValueString(GroupDescriptor.create(groupId, groupPriority), valueData));
            }
            catch (AssertionError assertionError) {}
        }
        try {
            this.setSentTime(Long.parseLong(element.getAttributeValue(LAST_TIME_ATTR, "0")));
        }
        catch (NumberFormatException e) {
            this.setSentTime(0L);
        }
        String isAllowedValue = element.getAttributeValue(IS_ALLOWED_ATTR);
        this.setAllowed(!StringUtil.isEmptyOrSpaces((String)isAllowedValue) && Boolean.parseBoolean(isAllowedValue));
        String isShowNotificationValue = element.getAttributeValue(SHOW_NOTIFICATION_ATTR);
        this.setShowNotification(StringUtil.isEmptyOrSpaces((String)isShowNotificationValue) || Boolean.parseBoolean(isShowNotificationValue));
        this.setPeriod(UsageStatisticsPersistenceComponent.parsePeriod(element.getAttributeValue(PERIOD_ATTR)));
    }

    public Element getState() {
        Element element = new Element("state");
        for (Map.Entry entry : ConvertUsagesUtil.sortDescriptorsByPriority(this.getSentUsages()).entrySet()) {
            Element projectElement = new Element(GROUP_TAG);
            projectElement.setAttribute(GROUP_ID_ATTR, entry.getKey().getId());
            projectElement.setAttribute(GROUP_PRIORITY_ATTR, Double.toString(entry.getKey().getPriority()));
            projectElement.setAttribute(DATA_ATTR, ConvertUsagesUtil.convertValueMap(entry.getValue()));
            element.addContent(projectElement);
        }
        long lastTimeSent = this.getLastTimeSent();
        if (lastTimeSent > 0L) {
            element.setAttribute(LAST_TIME_ATTR, String.valueOf(lastTimeSent));
        }
        if (this.isAllowed()) {
            element.setAttribute(IS_ALLOWED_ATTR, "true");
        }
        if (!this.isShowNotification()) {
            element.setAttribute(SHOW_NOTIFICATION_ATTR, "false");
        }
        if (this.myPeriod != SendPeriod.WEEKLY) {
            element.setAttribute(PERIOD_ATTR, this.myPeriod.getName());
        }
        return element;
    }

    @NotNull
    public SendPeriod getPeriod() {
        return this.myPeriod;
    }

    public void setPeriod(@NotNull SendPeriod period) {
        this.myPeriod = period;
    }

    @NotNull
    private static SendPeriod parsePeriod(@Nullable String periodAttrValue) {
        if (SendPeriod.DAILY.getName().equals(periodAttrValue)) {
            return SendPeriod.DAILY;
        }
        if (SendPeriod.MONTHLY.getName().equals(periodAttrValue)) {
            return SendPeriod.MONTHLY;
        }
        return SendPeriod.WEEKLY;
    }

    public void setAllowed(boolean allowed) {
        this.isAllowed = allowed;
        this.updateAndroidStudioMetrics(allowed);
    }

    private void updateAndroidStudioMetrics(boolean allowed) {
        final Logger intelliJLogger = Logger.getInstance((String)"#com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent");
        ILogger logger = new ILogger(){

            public void error(Throwable t, String msgFormat, Object ... args) {
                intelliJLogger.error(String.format(msgFormat, args), t);
            }

            public void warning(String msgFormat, Object ... args) {
                intelliJLogger.warn(String.format(msgFormat, args));
            }

            public void info(String msgFormat, Object ... args) {
                intelliJLogger.info(String.format(msgFormat, args));
            }

            public void verbose(String msgFormat, Object ... args) {
                this.info(msgFormat, args);
            }
        };
        ScheduledExecutorService scheduler = JobScheduler.getScheduler();
        AnalyticsSettings settings = UsageTracker.updateSettingsAndTracker((boolean)allowed, (ILogger)logger, (ScheduledExecutorService)scheduler);
        UsageTracker tracker = UsageTracker.getInstance();
        tracker.setMaxJournalTime(10L, TimeUnit.MINUTES);
        tracker.setMaxJournalSize(1000);
        ApplicationInfo application = ApplicationInfo.getInstance();
        AnalyticsPublisher.updatePublisher((ILogger)logger, (AnalyticsSettings)settings, (ScheduledExecutorService)scheduler, (String)application.getStrictVersion());
    }

    @Override
    public boolean isAllowed() {
        return this.isAllowed;
    }

    public void setShowNotification(boolean showNotification2) {
        this.isShowNotification = showNotification2;
    }

    @Override
    public boolean isShowNotification() {
        return this.isShowNotification;
    }

    private static double getPriority(String priority) {
        if (StringUtil.isEmptyOrSpaces((String)priority)) {
            return 0.0;
        }
        return Double.parseDouble(priority);
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        return "SentUsagesPersistenceComponent";
    }
}

