/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.updater;

import com.intellij.internal.statistic.configurable.StatisticsConfigurable;
import com.intellij.internal.statistic.connect.StatisticsService;
import com.intellij.internal.statistic.persistence.UsageStatisticsPersistenceComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class StatisticsNotificationManager {
    public static final String GROUP_DISPLAY_ID = "IDE Usage Statistics";

    private StatisticsNotificationManager() {
    }

    public static void showNotification(@NotNull StatisticsService statisticsService) {
        MyNotificationListener listener2 = new MyNotificationListener(statisticsService, UsageStatisticsPersistenceComponent.getInstance());
        Notifications.Bus.notify((Notification)statisticsService.createNotification(GROUP_DISPLAY_ID, listener2));
    }

    private static class MyNotificationListener
    implements NotificationListener {
        private StatisticsService myStatisticsService;
        private final UsageStatisticsPersistenceComponent mySettings;

        public MyNotificationListener(@NotNull StatisticsService statisticsService, @NotNull UsageStatisticsPersistenceComponent settings) {
            this.myStatisticsService = statisticsService;
            this.mySettings = settings;
        }

        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String description = event.getDescription();
                if ("allow".equals(description)) {
                    this.mySettings.setAllowed(true);
                    this.mySettings.setShowNotification(false);
                    notification.expire();
                    ApplicationManager.getApplication().executeOnPooledThread(() -> this.myStatisticsService.send());
                } else if ("decline".equals(description)) {
                    this.mySettings.setAllowed(false);
                    this.mySettings.setShowNotification(false);
                    notification.expire();
                } else if ("settings".equals(description)) {
                    ShowSettingsUtil util = ShowSettingsUtil.getInstance();
                    IdeFrame ideFrame = WindowManagerEx.getInstanceEx().findFrameFor(null);
                    util.editConfigurable((Component)((JFrame)ideFrame), (Configurable)new StatisticsConfigurable(true));
                    notification.expire();
                }
            }
        }
    }
}

