/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javadoc;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.javadoc.JavadocHelper;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EnterInJavadocParamDescriptionHandler
extends EnterHandlerDelegateAdapter {
    private final JavadocHelper myHelper = JavadocHelper.getInstance();

    @Override
    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull DataContext dataContext) {
        if (!(file2 instanceof PsiJavaFile && CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER && CodeStyleSettingsManager.getSettings((Project)file2.getProject()).JD_ALIGN_PARAM_COMMENTS)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        CaretModel caretModel = editor.getCaretModel();
        int caretOffset = caretModel.getOffset();
        if (!EnterInJavadocParamDescriptionHandler.isInJavaDoc(editor, caretOffset)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Pair<JavadocHelper.JavadocParameterInfo, List<JavadocHelper.JavadocParameterInfo>> pair = this.myHelper.parse(file2, editor, caretOffset);
        if (pair.first == null || ((JavadocHelper.JavadocParameterInfo)pair.first).parameterDescriptionStartPosition == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        LogicalPosition caretPosition = caretModel.getLogicalPosition();
        LogicalPosition nameEndPosition = ((JavadocHelper.JavadocParameterInfo)pair.first).parameterNameEndPosition;
        if (nameEndPosition.line == caretPosition.line && caretPosition.column <= nameEndPosition.column) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int descriptionStartColumn = ((JavadocHelper.JavadocParameterInfo)pair.first).parameterDescriptionStartPosition.column;
        LogicalPosition desiredPosition = new LogicalPosition(caretPosition.line, descriptionStartColumn);
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        int offsetAfterLastWs = CharArrayUtil.shiftForward((CharSequence)text, (int)caretOffset, (String)" \t");
        if (editor.offsetToLogicalPosition((int)offsetAfterLastWs).column < desiredPosition.column) {
            int lineStartOffset = document.getLineStartOffset(desiredPosition.line);
            String toInsert = StringUtil.repeat((String)" ", (int)(desiredPosition.column - (offsetAfterLastWs - lineStartOffset)));
            ApplicationManager.getApplication().runWriteAction(() -> {
                document.insertString(caretOffset, (CharSequence)toInsert);
                PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(document);
            });
        }
        this.myHelper.navigate(desiredPosition, editor, file2.getProject());
        return EnterHandlerDelegate.Result.Stop;
    }

    private static boolean isInJavaDoc(@NotNull Editor editor, int offset) {
        Document document = editor.getDocument();
        CharSequence docChars = document.getCharsSequence();
        int i2 = CharArrayUtil.lastIndexOf((CharSequence)docChars, (String)"/**", (int)offset);
        if (i2 >= 0) {
            return (i2 = CharArrayUtil.indexOf((CharSequence)docChars, (CharSequence)"*/", (int)i2)) > offset;
        }
        return false;
    }
}

