/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javadoc;

import com.intellij.CommonBundle;
import com.intellij.analysis.AnalysisScope;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.javadoc.JavadocConfiguration;
import com.intellij.javadoc.JavadocGeneratorRunProfile;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="JavadocGenerationManager")
public final class JavadocGenerationManager
implements PersistentStateComponent<Element> {
    private final JavadocConfiguration myConfiguration = new JavadocConfiguration();
    private final Project myProject;

    public static JavadocGenerationManager getInstance(@NotNull Project project2) {
        return (JavadocGenerationManager)ServiceManager.getService((Project)project2, JavadocGenerationManager.class);
    }

    JavadocGenerationManager(Project project2) {
        this.myProject = project2;
    }

    public Element getState() {
        return XmlSerializer.serialize((Object)this.myConfiguration, (SerializationFilter)JavadocConfiguration.FILTER);
    }

    public void loadState(Element state) {
        XmlSerializer.deserializeInto((Object)this.myConfiguration, (Element)state);
    }

    @NotNull
    public JavadocConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    public void generateJavadoc(AnalysisScope scope) {
        try {
            JavadocGeneratorRunProfile profile2 = new JavadocGeneratorRunProfile(this.myProject, scope, this.myConfiguration);
            ExecutionEnvironmentBuilder.create((Project)this.myProject, (Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunProfile)profile2).buildAndExecute();
        }
        catch (ExecutionException e) {
            ExecutionErrorDialog.show((ExecutionException)e, (String)CommonBundle.getErrorTitle(), (Project)this.myProject);
        }
    }
}

