/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonLexer;
import com.intellij.json.JsonParserDefinition;
import com.intellij.lang.refactoring.NamesValidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class JsonNamesValidator
implements NamesValidator {
    private final JsonLexer myLexer = new JsonLexer();

    public synchronized boolean isKeyword(@NotNull String name, Project project2) {
        this.myLexer.start(name);
        return JsonParserDefinition.JSON_KEYWORDS.contains(this.myLexer.getTokenType()) && this.myLexer.getTokenEnd() == name.length();
    }

    public synchronized boolean isIdentifier(@NotNull String name, Project project2) {
        if (!StringUtil.startsWithChar((CharSequence)name, (char)'\'') && !StringUtil.startsWithChar((CharSequence)name, (char)'\"')) {
            name = "\"" + name;
        }
        if (!StringUtil.endsWithChar((CharSequence)name, (char)'\"') && !StringUtil.endsWithChar((CharSequence)name, (char)'\"')) {
            name = name + "\"";
        }
        this.myLexer.start(name);
        IElementType type2 = this.myLexer.getTokenType();
        return this.myLexer.getTokenEnd() == name.length() && (type2 == JsonElementTypes.DOUBLE_QUOTED_STRING || type2 == JsonElementTypes.SINGLE_QUOTED_STRING);
    }
}

