/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.editor.folding;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonFoldingBuilder
implements FoldingBuilder,
DumbAware {
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        JsonFoldingBuilder.collectDescriptorsRecursively(node, document, descriptors);
        return descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
    }

    private static void collectDescriptorsRecursively(@NotNull ASTNode node, @NotNull Document document, @NotNull List<FoldingDescriptor> descriptors) {
        IElementType type2 = node.getElementType();
        if ((type2 == JsonElementTypes.OBJECT || type2 == JsonElementTypes.ARRAY) && JsonFoldingBuilder.spanMultipleLines(node, document)) {
            descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
        } else if (type2 == JsonElementTypes.BLOCK_COMMENT) {
            descriptors.add(new FoldingDescriptor(node, node.getTextRange()));
        } else if (type2 == JsonElementTypes.LINE_COMMENT) {
            Couple<PsiElement> commentRange = JsonFoldingBuilder.expandLineCommentsRange(node.getPsi());
            int startOffset = ((PsiElement)commentRange.getFirst()).getTextRange().getStartOffset();
            int endOffset = ((PsiElement)commentRange.getSecond()).getTextRange().getEndOffset();
            if (document.getLineNumber(startOffset) != document.getLineNumber(endOffset)) {
                descriptors.add(new FoldingDescriptor(node, new TextRange(startOffset, endOffset)));
            }
        }
        for (ASTNode child : node.getChildren(null)) {
            JsonFoldingBuilder.collectDescriptorsRecursively(child, document, descriptors);
        }
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        IElementType type2 = node.getElementType();
        if (type2 == JsonElementTypes.OBJECT) {
            JsonObject object = (JsonObject)node.getPsi(JsonObject.class);
            List<JsonProperty> properties = object.getPropertyList();
            JsonProperty candidate = null;
            for (JsonProperty property : properties) {
                String name = property.getName();
                JsonValue value2 = property.getValue();
                if (!(value2 instanceof JsonLiteral)) continue;
                if ("id".equals(name) || "name".equals(name)) {
                    candidate = property;
                    break;
                }
                if (candidate != null) continue;
                candidate = property;
            }
            if (candidate != null) {
                return "{\"" + candidate.getName() + "\": " + candidate.getValue().getText() + "...}";
            }
            return "{...}";
        }
        if (type2 == JsonElementTypes.ARRAY) {
            return "[...]";
        }
        if (type2 == JsonElementTypes.LINE_COMMENT) {
            return "//...";
        }
        if (type2 == JsonElementTypes.BLOCK_COMMENT) {
            return "/*...*/";
        }
        return "...";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        return false;
    }

    @NotNull
    public static Couple<PsiElement> expandLineCommentsRange(@NotNull PsiElement anchor) {
        return Couple.of((Object)JsonPsiUtil.findFurthestSiblingOfSameType(anchor, false), (Object)JsonPsiUtil.findFurthestSiblingOfSameType(anchor, true));
    }

    private static boolean spanMultipleLines(@NotNull ASTNode node, @NotNull Document document) {
        TextRange range = node.getTextRange();
        return document.getLineNumber(range.getStartOffset()) < document.getLineNumber(range.getEndOffset());
    }
}

