/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.formatter;

import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonLanguage;
import com.intellij.json.formatter.JsonCodeStyleSettings;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.impl.JsonRecursiveElementVisitor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsonTrailingCommaRemover
implements PreFormatProcessor {
    @Override
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        PsiElement rootPsi = element.getPsi();
        if (rootPsi.getLanguage() != JsonLanguage.INSTANCE) {
            return range;
        }
        JsonCodeStyleSettings settings = (JsonCodeStyleSettings)CodeStyleSettingsManager.getInstance((Project)rootPsi.getProject()).getCurrentSettings().getCustomSettings(JsonCodeStyleSettings.class);
        if (!settings.REMOVE_TRAILING_COMMA) {
            return range;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)rootPsi.getProject());
        Document document = psiDocumentManager.getDocument(rootPsi.getContainingFile());
        if (document == null) {
            return range;
        }
        DocumentUtil.executeInBulk(document, true, () -> {
            psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
            Visitor visitor = new Visitor(document);
            rootPsi.accept((PsiElementVisitor)visitor);
            psiDocumentManager.commitDocument(document);
        });
        return range;
    }

    private static class Visitor
    extends JsonRecursiveElementVisitor {
        private final Document myDocument;
        private int myOffsetDelta;

        public Visitor(Document document) {
            this.myDocument = document;
        }

        @Override
        public void visitArray(@NotNull JsonArray o) {
            super.visitArray(o);
            Visitor.collectTrailingCommas(o).forEach(this::deleteNode);
        }

        @Override
        public void visitObject(@NotNull JsonObject o) {
            super.visitObject(o);
            Visitor.collectTrailingCommas(o).forEach(this::deleteNode);
        }

        @NotNull
        private static Collection<ASTNode> collectTrailingCommas(@NotNull PsiElement element) {
            ArrayList result2 = ContainerUtil.newArrayList();
            element = element.getLastChild();
            while (element != null) {
                if ((element = element.getPrevSibling()) != null && element.getNode().getElementType() == JsonElementTypes.COMMA || element instanceof PsiErrorElement && ",".equals(element.getText())) {
                    result2.add(element.getNode());
                    continue;
                }
                if (element instanceof PsiComment || element instanceof PsiWhiteSpace) continue;
                break;
            }
            return ContainerUtil.reverse((List)result2);
        }

        private void deleteNode(@NotNull ASTNode node) {
            int length = node.getTextLength();
            this.myDocument.deleteString(node.getStartOffset() + this.myOffsetDelta, node.getStartOffset() + length + this.myOffsetDelta);
            this.myOffsetDelta -= length;
        }
    }
}

