/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi.impl;

import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonPropertyNameReference
implements PsiReference {
    private final JsonProperty myProperty;

    public JsonPropertyNameReference(@NotNull JsonProperty property) {
        this.myProperty = property;
    }

    public PsiElement getElement() {
        return this.myProperty;
    }

    public TextRange getRangeInElement() {
        JsonValue nameElement = this.myProperty.getNameElement();
        return ElementManipulators.getValueTextRange((PsiElement)nameElement);
    }

    @Nullable
    public PsiElement resolve() {
        return this.myProperty;
    }

    @NotNull
    public String getCanonicalText() {
        return this.myProperty.getName();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.myProperty.setName(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        if (!(element instanceof JsonProperty)) {
            return false;
        }
        JsonProperty otherProperty = (JsonProperty)element;
        PsiElement selfResolve = this.resolve();
        return otherProperty.getName().equals(this.getCanonicalText()) && selfResolve != otherProperty;
    }

    @NotNull
    public Object[] getVariants() {
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return true;
    }
}

