/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.psi.impl;

import com.intellij.icons.AllIcons;
import com.intellij.json.JsonBundle;
import com.intellij.json.JsonParserDefinition;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonBooleanLiteral;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonNumberLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiChangeUtils;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonReferenceExpression;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonPsiImplUtils {
    private static final Key<List<Pair<TextRange, String>>> STRING_FRAGMENTS = new Key("JSON string fragments");
    private static final String ourEscapesTable = "\"\"\\\\//b\bf\fn\nr\rt\t";

    @NotNull
    public static String getName(@NotNull JsonProperty property) {
        return StringUtil.unescapeStringCharacters((String)JsonPsiUtil.stripQuotes(property.getNameElement().getText()));
    }

    @NotNull
    public static JsonValue getNameElement(@NotNull JsonProperty property) {
        PsiElement firstChild = property.getFirstChild();
        assert (firstChild instanceof JsonLiteral || firstChild instanceof JsonReferenceExpression);
        return (JsonValue)firstChild;
    }

    @Nullable
    public static JsonValue getValue(@NotNull JsonProperty property) {
        return (JsonValue)PsiTreeUtil.getNextSiblingOfType((PsiElement)JsonPsiImplUtils.getNameElement(property), JsonValue.class);
    }

    public static boolean isQuotedString(@NotNull JsonLiteral literal) {
        return literal.getNode().findChildByType(JsonParserDefinition.STRING_LITERALS) != null;
    }

    @Nullable
    public static ItemPresentation getPresentation(final @NotNull JsonProperty property) {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                return property.getName();
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                if (property.getValue() instanceof JsonArray) {
                    return AllIcons.Json.Property_brackets;
                }
                if (property.getValue() instanceof JsonObject) {
                    return AllIcons.Json.Property_braces;
                }
                return PlatformIcons.PROPERTY_ICON;
            }
        };
    }

    @Nullable
    public static ItemPresentation getPresentation(@NotNull JsonArray array) {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                return JsonBundle.message("json.array", new Object[0]);
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return AllIcons.Json.Array;
            }
        };
    }

    @Nullable
    public static ItemPresentation getPresentation(@NotNull JsonObject object) {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                return JsonBundle.message("json.object", new Object[0]);
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return AllIcons.Json.Object;
            }
        };
    }

    @NotNull
    public static List<Pair<TextRange, String>> getTextFragments(@NotNull JsonStringLiteral literal) {
        List<Pair> result2 = (ArrayList<Pair>)literal.getUserData(STRING_FRAGMENTS);
        if (result2 == null) {
            int contentEnd;
            result2 = new ArrayList<Pair>();
            String text = literal.getText();
            int length = text.length();
            int pos = 1;
            int unescapedSequenceStart = 1;
            while (pos < length) {
                if (text.charAt(pos) == '\\') {
                    if (unescapedSequenceStart != pos) {
                        result2.add(Pair.create((Object)new TextRange(unescapedSequenceStart, pos), (Object)text.substring(unescapedSequenceStart, pos)));
                    }
                    if (pos == length - 1) {
                        result2.add(Pair.create((Object)new TextRange(pos, pos + 1), (Object)"\\"));
                        break;
                    }
                    char next = text.charAt(pos + 1);
                    switch (next) {
                        case '\"': 
                        case '/': 
                        case '\\': 
                        case 'b': 
                        case 'f': 
                        case 'n': 
                        case 'r': 
                        case 't': {
                            int idx = ourEscapesTable.indexOf(next);
                            result2.add(Pair.create((Object)new TextRange(pos, pos + 2), (Object)ourEscapesTable.substring(idx + 1, idx + 2)));
                            pos += 2;
                            break;
                        }
                        case 'u': {
                            int i2;
                            for (i2 = pos + 2; i2 < pos + 6 && i2 != length && StringUtil.isHexDigit((char)text.charAt(i2)); ++i2) {
                            }
                            result2.add(Pair.create((Object)new TextRange(pos, i2), (Object)text.substring(pos, i2)));
                            pos = i2;
                            break;
                        }
                        default: {
                            result2.add(Pair.create((Object)new TextRange(pos, pos + 2), (Object)text.substring(pos, pos + 2)));
                            pos += 2;
                        }
                    }
                    unescapedSequenceStart = pos;
                    continue;
                }
                ++pos;
            }
            int n = contentEnd = text.charAt(0) == text.charAt(length - 1) ? length - 1 : length;
            if (unescapedSequenceStart < contentEnd) {
                result2.add(Pair.create((Object)new TextRange(unescapedSequenceStart, length), (Object)text.substring(unescapedSequenceStart, contentEnd)));
            }
            result2 = Collections.unmodifiableList(result2);
            literal.putUserData(STRING_FRAGMENTS, result2);
        }
        return result2;
    }

    public static void delete(@NotNull JsonProperty property) {
        ASTNode myNode = property.getNode();
        JsonPsiChangeUtils.removeCommaSeparatedFromList(myNode, myNode.getTreeParent());
    }

    @NotNull
    public static String getValue(@NotNull JsonStringLiteral literal) {
        return StringUtil.unescapeStringCharacters((String)JsonPsiUtil.stripQuotes(literal.getText()));
    }

    public static boolean getValue(@NotNull JsonBooleanLiteral literal) {
        return literal.textMatches("true");
    }

    public static double getValue(@NotNull JsonNumberLiteral literal) {
        return Double.parseDouble(literal.getText());
    }
}

