/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.LanguageASTFactory;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.CharTableImpl;
import com.intellij.psi.impl.source.CodeFragmentElement;
import com.intellij.psi.impl.source.DummyHolderElement;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LazyParseableElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import com.intellij.psi.tree.ICompositeElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.ILeafElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ASTFactory {
    private static final CharTable WHITESPACES = new CharTableImpl();

    @Nullable
    public LazyParseableElement createLazy(ILazyParseableElementType type2, CharSequence text) {
        return null;
    }

    @Nullable
    public CompositeElement createComposite(IElementType type2) {
        return null;
    }

    @Nullable
    public LeafElement createLeaf(@NotNull IElementType type2, @NotNull CharSequence text) {
        return null;
    }

    @NotNull
    public static LazyParseableElement lazy(@NotNull ILazyParseableElementType type2, CharSequence text) {
        ASTNode node = type2.createNode(text);
        if (node != null) {
            return (LazyParseableElement)node;
        }
        if (type2 == TokenType.CODE_FRAGMENT) {
            return new CodeFragmentElement(null);
        }
        if (type2 == TokenType.DUMMY_HOLDER) {
            return new DummyHolderElement(text);
        }
        LazyParseableElement customLazy = ASTFactory.factory((IElementType)type2).createLazy(type2, text);
        return customLazy != null ? customLazy : DefaultFactoryHolder.DEFAULT.createLazy(type2, text);
    }

    @NotNull
    public static CompositeElement composite(@NotNull IElementType type2) {
        if (type2 instanceof ICompositeElementType) {
            return (CompositeElement)((ICompositeElementType)type2).createCompositeNode();
        }
        CompositeElement customComposite = ASTFactory.factory(type2).createComposite(type2);
        return customComposite != null ? customComposite : DefaultFactoryHolder.DEFAULT.createComposite(type2);
    }

    @NotNull
    public static LeafElement leaf(@NotNull IElementType type2, @NotNull CharSequence text) {
        if (type2 == TokenType.WHITE_SPACE) {
            return new PsiWhiteSpaceImpl(text);
        }
        if (type2 instanceof ILeafElementType) {
            return (LeafElement)((ILeafElementType)type2).createLeafNode(text);
        }
        LeafElement customLeaf = ASTFactory.factory(type2).createLeaf(type2, text);
        return customLeaf != null ? customLeaf : DefaultFactoryHolder.DEFAULT.createLeaf(type2, text);
    }

    @Nullable
    private static ASTFactory factory(IElementType type2) {
        return (ASTFactory)LanguageASTFactory.INSTANCE.forLanguage(type2.getLanguage());
    }

    @NotNull
    public static LeafElement whitespace(CharSequence text) {
        PsiWhiteSpaceImpl w = new PsiWhiteSpaceImpl(WHITESPACES.intern(text));
        CodeEditUtil.setNodeGenerated(w, true);
        return w;
    }

    public static class DefaultFactoryHolder {
        public static final ASTFactory DEFAULT = (ASTFactory)ServiceManager.getService(DefaultASTFactory.class);

        private DefaultFactoryHolder() {
        }
    }
}

