/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TreeTraversal;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ReadOnlyASTNode
extends UserDataHolderBase
implements ASTNode {
    private final ReadOnlyASTNode myParent;
    private final int myIndex;

    public ReadOnlyASTNode(@Nullable ReadOnlyASTNode parent, int index) {
        this.myParent = parent;
        this.myIndex = index;
    }

    @NotNull
    public List<ASTNode> getChildList() {
        return ContainerUtil.immutableList((Object[])this.getChildArray());
    }

    protected abstract ASTNode[] getChildArray();

    public ReadOnlyASTNode getTreeParent() {
        return this.myParent;
    }

    public <T extends PsiElement> T getPsi(@NotNull Class<T> clazz) {
        return (T)((PsiElement)ObjectUtils.tryCast((Object)this.getPsi(), clazz));
    }

    public ASTNode getFirstChildNode() {
        ASTNode[] kids = this.getChildArray();
        return kids.length > 0 ? kids[0] : null;
    }

    public ASTNode getLastChildNode() {
        ASTNode[] kids = this.getChildArray();
        return kids.length > 0 ? kids[kids.length - 1] : null;
    }

    public ASTNode getTreeNext() {
        ASTNode[] kids = this.getTreeParent().getChildArray();
        return kids.length > this.myIndex + 1 ? kids[this.myIndex + 1] : null;
    }

    public ASTNode getTreePrev() {
        return this.myIndex > 0 ? this.getTreeParent().getChildArray()[this.myIndex - 1] : null;
    }

    @NotNull
    public ASTNode[] getChildren(@Nullable TokenSet filter) {
        ASTNode[] kids = this.getChildArray();
        return kids.length == 0 ? EMPTY_ARRAY : (ASTNode[])kids.clone();
    }

    @NotNull
    public String getText() {
        return this.getChars().toString();
    }

    public boolean textContains(char c) {
        return StringUtil.indexOf((CharSequence)this.getChars(), (char)c) >= 0;
    }

    public int getStartOffset() {
        return this.getTextRange().getStartOffset();
    }

    public int getTextLength() {
        return this.getTextRange().getLength();
    }

    @NotNull
    public ReadOnlyASTNode clone() {
        return this;
    }

    public void addChild(@NotNull ASTNode child) {
        throw new UnsupportedOperationException();
    }

    public void addChild(@NotNull ASTNode child, @Nullable ASTNode anchorBefore) {
        throw new UnsupportedOperationException();
    }

    public void addLeaf(@NotNull IElementType leafType, CharSequence leafText, @Nullable ASTNode anchorBefore) {
        throw new UnsupportedOperationException();
    }

    public void removeChild(@NotNull ASTNode child) {
        throw new UnsupportedOperationException();
    }

    public void removeRange(@NotNull ASTNode firstNodeToRemove, ASTNode firstNodeToKeep) {
        throw new UnsupportedOperationException();
    }

    public void replaceChild(@NotNull ASTNode oldChild, @NotNull ASTNode newChild) {
        throw new UnsupportedOperationException();
    }

    public void replaceAllChildrenToChildrenOf(ASTNode anotherParent) {
        throw new UnsupportedOperationException();
    }

    public void addChildren(ASTNode firstChild, ASTNode firstChildToNotAdd, ASTNode anchorBefore) {
        throw new UnsupportedOperationException();
    }

    public ASTNode copyElement() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public ASTNode findLeafElementAt(int offset) {
        if (!this.getTextRange().contains(offset)) {
            return null;
        }
        return (ASTNode)((SyntaxTraverser)SyntaxTraverser.astTraverser((ASTNode)this).expandAndFilter(n -> n.getTextRange().contains(offset))).traverse(TreeTraversal.LEAVES_DFS).first();
    }

    @Nullable
    public ASTNode findChildByType(IElementType type2) {
        return this.findChildByType(type2, null);
    }

    @Nullable
    public ASTNode findChildByType(IElementType type2, @Nullable ASTNode anchor) {
        boolean flag = anchor == null;
        for (ASTNode node : this.getChildren(null)) {
            if (!flag && node.equals(anchor)) {
                flag = true;
            }
            if (!flag || node.getElementType() != type2) continue;
            return node;
        }
        return null;
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet) {
        return this.findChildByType(typesSet, null);
    }

    @Nullable
    public ASTNode findChildByType(@NotNull TokenSet typesSet, @Nullable ASTNode anchor) {
        boolean flag = anchor == null;
        for (ASTNode node : this.getChildren(null)) {
            if (!flag && node.equals(anchor)) {
                flag = true;
            }
            if (!flag || !typesSet.contains(node.getElementType())) continue;
            return node;
        }
        return null;
    }
}

