/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.customFolding;

import com.intellij.ide.IdeBundle;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.ui.components.JBList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomFoldingRegionsPopup {
    @NotNull
    private final JBList myRegionsList;
    @NotNull
    private final JBPopup myPopup;
    @NotNull
    private final Editor myEditor;

    CustomFoldingRegionsPopup(@NotNull Collection<FoldingDescriptor> descriptors, @NotNull Editor editor, @NotNull Project project2) {
        this.myEditor = editor;
        this.myRegionsList = new JBList();
        this.myRegionsList.setModel((ListModel)new MyListModel(CustomFoldingRegionsPopup.orderByPosition(descriptors)));
        this.myRegionsList.setSelectedIndex(0);
        PopupChooserBuilder popupBuilder = JBPopupFactory.getInstance().createListPopupBuilder((JList)this.myRegionsList);
        this.myPopup = popupBuilder.setTitle(IdeBundle.message((String)"goto.custom.region.command", (Object[])new Object[0])).setResizable(false).setMovable(false).setItemChoosenCallback(() -> {
            PsiElement navigationElement = this.getNavigationElement();
            if (navigationElement != null) {
                CustomFoldingRegionsPopup.navigateTo(editor, navigationElement);
                IdeDocumentHistory.getInstance(project2).includeCurrentCommandAsNavigation();
            }
        }).createPopup();
    }

    void show() {
        this.myPopup.showInBestPositionFor(this.myEditor);
    }

    @Nullable
    public PsiElement getNavigationElement() {
        Object selection = this.myRegionsList.getSelectedValue();
        if (selection instanceof MyFoldingDescriptorWrapper) {
            return ((MyFoldingDescriptorWrapper)selection).getDescriptor().getElement().getPsi();
        }
        return null;
    }

    private static Collection<FoldingDescriptor> orderByPosition(Collection<FoldingDescriptor> descriptors) {
        ArrayList<FoldingDescriptor> sorted = new ArrayList<FoldingDescriptor>(descriptors.size());
        sorted.addAll(descriptors);
        Collections.sort(sorted, (descriptor1, descriptor2) -> {
            int pos1 = descriptor1.getElement().getTextRange().getStartOffset();
            int pos2 = descriptor2.getElement().getTextRange().getStartOffset();
            return pos1 - pos2;
        });
        return sorted;
    }

    private static void navigateTo(@NotNull Editor editor, @NotNull PsiElement element) {
        int offset = element.getTextRange().getStartOffset();
        if (offset >= 0 && offset < editor.getDocument().getTextLength()) {
            editor.getCaretModel().removeSecondaryCarets();
            editor.getCaretModel().moveToOffset(offset);
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
            editor.getSelectionModel().removeSelection();
        }
    }

    private static class MyFoldingDescriptorWrapper {
        @NotNull
        private final FoldingDescriptor myDescriptor;

        private MyFoldingDescriptorWrapper(@NotNull FoldingDescriptor descriptor) {
            this.myDescriptor = descriptor;
        }

        @NotNull
        public FoldingDescriptor getDescriptor() {
            return this.myDescriptor;
        }

        @Nullable
        public String toString() {
            return this.myDescriptor.getPlaceholderText();
        }
    }

    private static class MyListModel
    extends DefaultListModel {
        private MyListModel(Collection<FoldingDescriptor> descriptors) {
            for (FoldingDescriptor descriptor : descriptors) {
                super.addElement(new MyFoldingDescriptorWrapper(descriptor));
            }
        }
    }
}

