/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomFoldingSurroundDescriptor
implements SurroundDescriptor {
    public static final CustomFoldingSurroundDescriptor INSTANCE = new CustomFoldingSurroundDescriptor();
    public static final CustomFoldingRegionSurrounder[] SURROUNDERS;
    private static final String DEFAULT_DESC_TEXT = "Description";

    @NotNull
    public PsiElement[] getElementsToSurround(PsiFile file2, int startOffset, int endOffset) {
        if (startOffset >= endOffset) {
            return PsiElement.EMPTY_ARRAY;
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(file2.getLanguage());
        if (commenter == null || commenter.getLineCommentPrefix() == null && (commenter.getBlockCommentPrefix() == null || commenter.getBlockCommentSuffix() == null)) {
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement startElement = file2.findElementAt(startOffset);
        PsiElement endElement = file2.findElementAt(endOffset - 1);
        if (startElement instanceof PsiWhiteSpace) {
            if (startElement == endElement) {
                return PsiElement.EMPTY_ARRAY;
            }
            startElement = startElement.getNextSibling();
        }
        if (endElement instanceof PsiWhiteSpace) {
            endElement = endElement.getPrevSibling();
        }
        if (startElement != null && endElement != null && (startElement = CustomFoldingSurroundDescriptor.findClosestParentAfterLineBreak(startElement)) != null && (endElement = CustomFoldingSurroundDescriptor.findClosestParentBeforeLineBreak(endElement)) != null) {
            return CustomFoldingSurroundDescriptor.adjustRange(startElement, endElement);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @NotNull
    private static PsiElement[] adjustRange(@NotNull PsiElement start, @NotNull PsiElement end) {
        PsiElement newEndParent;
        PsiElement newStart = CustomFoldingSurroundDescriptor.lowerStartElementIfNeeded(start, end);
        PsiElement newEnd = CustomFoldingSurroundDescriptor.lowerEndElementIfNeeded(start, end);
        if (newStart == null || newEnd == null) {
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement commonParent = CustomFoldingSurroundDescriptor.findCommonAncestorForWholeRange(newStart, newEnd);
        if (commonParent != null) {
            return new PsiElement[]{commonParent};
        }
        PsiElement newStartParent = CustomFoldingSurroundDescriptor.getParent(newStart);
        if (newStartParent != null && newStartParent.getFirstChild() == newStart && newStart.getFirstChild() == null) {
            newStart = newStartParent;
        }
        if ((newEndParent = CustomFoldingSurroundDescriptor.getParent(newEnd)) != null && newEndParent.getLastChild() == newEnd && newEnd.getFirstChild() == null) {
            newEnd = newEndParent;
        }
        if (CustomFoldingSurroundDescriptor.getParent(newStart) == CustomFoldingSurroundDescriptor.getParent(newEnd)) {
            return new PsiElement[]{newStart, newEnd};
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Nullable
    private static PsiElement getParent(@Nullable PsiElement e) {
        return e instanceof PsiFile ? e : PsiTreeUtil.skipParentsOfType((PsiElement)e, (Class[])new Class[]{GeneratedParserUtilBase.DummyBlock.class});
    }

    @Nullable
    private static PsiElement lowerEndElementIfNeeded(@NotNull PsiElement start, @NotNull PsiElement end) {
        if (PsiTreeUtil.isAncestor((PsiElement)end, (PsiElement)start, (boolean)true)) {
            PsiElement o = end.getLastChild();
            while (o != null && o.getParent() != start.getParent()) {
                PsiElement last = o.getLastChild();
                if (last == null) {
                    return o;
                }
                o = last;
            }
            return o;
        }
        return end;
    }

    @Nullable
    private static PsiElement lowerStartElementIfNeeded(@NotNull PsiElement start, @NotNull PsiElement end) {
        if (PsiTreeUtil.isAncestor((PsiElement)start, (PsiElement)end, (boolean)true)) {
            PsiElement o = start.getFirstChild();
            while (o != null && o.getParent() != end.getParent()) {
                PsiElement first = o.getFirstChild();
                if (first == null) {
                    return o;
                }
                o = first;
            }
            return o;
        }
        return start;
    }

    @Nullable
    private static PsiElement findCommonAncestorForWholeRange(@NotNull PsiElement start, @NotNull PsiElement end) {
        if (start.getContainingFile() != end.getContainingFile()) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)start, (PsiElement)end);
        if (parent == null) {
            return null;
        }
        TextRange parentRange = parent.getTextRange();
        if (parentRange.getStartOffset() == start.getTextRange().getStartOffset() && parentRange.getEndOffset() == end.getTextRange().getEndOffset()) {
            return parent;
        }
        return null;
    }

    @Nullable
    private static PsiElement findClosestParentAfterLineBreak(PsiElement element) {
        for (PsiElement parent = element; parent != null && !(parent instanceof PsiFileSystemItem); parent = parent.getParent()) {
            PsiElement prev;
            for (prev = parent.getPrevSibling(); prev != null && prev.getTextLength() <= 0; prev = prev.getPrevSibling()) {
            }
            if (CustomFoldingSurroundDescriptor.firstElementInFile(parent)) {
                return parent.getContainingFile();
            }
            if (!CustomFoldingSurroundDescriptor.isWhiteSpaceWithLineFeed(prev)) continue;
            return parent;
        }
        return null;
    }

    private static boolean firstElementInFile(@NotNull PsiElement element) {
        return element.getTextOffset() == 0;
    }

    @Nullable
    private static PsiElement findClosestParentBeforeLineBreak(PsiElement element) {
        for (PsiElement parent = element; parent != null && !(parent instanceof PsiFileSystemItem); parent = parent.getParent()) {
            PsiElement next = parent.getNextSibling();
            if (CustomFoldingSurroundDescriptor.lastElementInFile(parent)) {
                return parent.getContainingFile();
            }
            if (!CustomFoldingSurroundDescriptor.isWhiteSpaceWithLineFeed(next)) continue;
            return parent;
        }
        return null;
    }

    private static boolean lastElementInFile(@NotNull PsiElement element) {
        return element.getTextRange().getEndOffset() == element.getContainingFile().getTextRange().getEndOffset();
    }

    private static boolean isWhiteSpaceWithLineFeed(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        if (element instanceof PsiWhiteSpace) {
            return element.textContains('\n');
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return false;
        }
        CharSequence text = node.getChars();
        boolean lineFeedFound = false;
        for (int i2 = 0; i2 < text.length(); ++i2) {
            char c = text.charAt(i2);
            if (!StringUtil.isWhiteSpace((char)c)) {
                return false;
            }
            lineFeedFound |= c == '\n';
        }
        return lineFeedFound;
    }

    @NotNull
    public Surrounder[] getSurrounders() {
        return SURROUNDERS;
    }

    public boolean isExclusive() {
        return false;
    }

    static {
        ArrayList<CustomFoldingRegionSurrounder> surrounderList = new ArrayList<CustomFoldingRegionSurrounder>();
        for (CustomFoldingProvider provider2 : CustomFoldingProvider.getAllProviders()) {
            surrounderList.add(new CustomFoldingRegionSurrounder(provider2));
        }
        SURROUNDERS = surrounderList.toArray(new CustomFoldingRegionSurrounder[surrounderList.size()]);
    }

    private static class CustomFoldingRegionSurrounder
    implements Surrounder {
        private final CustomFoldingProvider myProvider;

        public CustomFoldingRegionSurrounder(@NotNull CustomFoldingProvider provider2) {
            this.myProvider = provider2;
        }

        public String getTemplateDescription() {
            return this.myProvider.getDescription();
        }

        public boolean isApplicable(@NotNull PsiElement[] elements) {
            if (elements.length == 0) {
                return false;
            }
            if (elements[0].getContainingFile() instanceof PsiCodeFragment) {
                return false;
            }
            for (FoldingBuilder each : LanguageFolding.INSTANCE.allForLanguage(elements[0].getLanguage())) {
                if (!(each instanceof CustomFoldingBuilder)) continue;
                return true;
            }
            return false;
        }

        public TextRange surroundElements(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiElement[] elements) throws IncorrectOperationException {
            if (elements.length == 0) {
                return null;
            }
            PsiElement firstElement = elements[0];
            PsiElement lastElement = elements[elements.length - 1];
            PsiFile psiFile = firstElement.getContainingFile();
            Language language = psiFile.getLanguage();
            Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
            if (commenter == null) {
                return null;
            }
            String linePrefix = commenter.getLineCommentPrefix();
            String lineSuffix = "";
            if (linePrefix == null) {
                linePrefix = commenter.getBlockCommentPrefix();
                lineSuffix = StringUtil.notNullize((String)commenter.getBlockCommentSuffix());
            }
            if (linePrefix == null) {
                return null;
            }
            int prefixLength = linePrefix.length();
            int startOffset = firstElement.getTextRange().getStartOffset();
            Document document = editor.getDocument();
            int startLineNumber = document.getLineNumber(startOffset);
            String startIndent = document.getText(new TextRange(document.getLineStartOffset(startLineNumber), startOffset));
            int endOffset = lastElement.getTextRange().getEndOffset();
            int delta = 0;
            TextRange rangeToSelect = TextRange.create((int)startOffset, (int)startOffset);
            String startText = this.myProvider.getStartString();
            int descPos = startText.indexOf("?");
            if (descPos >= 0) {
                startText = startText.replace("?", CustomFoldingSurroundDescriptor.DEFAULT_DESC_TEXT);
                rangeToSelect = TextRange.from((int)(startOffset + descPos), (int)CustomFoldingSurroundDescriptor.DEFAULT_DESC_TEXT.length());
            }
            String startString = linePrefix + startText + lineSuffix + "\n" + startIndent;
            String endString = "\n" + linePrefix + this.myProvider.getEndString() + lineSuffix;
            document.insertString(endOffset, (CharSequence)endString);
            delta += endString.length();
            document.insertString(startOffset, (CharSequence)startString);
            RangeMarker rangeMarkerToSelect = document.createRangeMarker(rangeToSelect.shiftRight(prefixLength));
            PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
            CustomFoldingRegionSurrounder.adjustLineIndent(project2, psiFile, language, TextRange.from((int)(endOffset + (delta += startString.length()) - endString.length()), (int)endString.length()));
            CustomFoldingRegionSurrounder.adjustLineIndent(project2, psiFile, language, TextRange.from((int)startOffset, (int)startString.length()));
            rangeToSelect = TextRange.create((int)rangeMarkerToSelect.getStartOffset(), (int)rangeMarkerToSelect.getEndOffset());
            rangeMarkerToSelect.dispose();
            return rangeToSelect;
        }

        private static void adjustLineIndent(@NotNull Project project2, PsiFile file2, Language language, TextRange range) {
            CommonCodeStyleSettings formatSettings = CodeStyleSettingsManager.getSettings((Project)project2).getCommonSettings(language);
            boolean keepAtFirstCol = formatSettings.KEEP_FIRST_COLUMN_COMMENT;
            formatSettings.KEEP_FIRST_COLUMN_COMMENT = false;
            CodeStyleManager.getInstance((Project)project2).adjustLineIndent(file2, range);
            formatSettings.KEEP_FIRST_COLUMN_COMMENT = keepAtFirstCol;
        }
    }
}

