/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.lexer;

import com.intellij.lang.java.lexer._JavaLexer;
import com.intellij.lexer.LexerBase;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceHashingStrategy;
import gnu.trove.TObjectHashingStrategy;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaLexer
extends LexerBase {
    private static final Set<String> KEYWORDS = ContainerUtil.newTroveSet((Object[])new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null"});
    private static final Set<CharSequence> JAVA9_KEYWORDS = ContainerUtil.newTroveSet((TObjectHashingStrategy)CharSequenceHashingStrategy.CASE_SENSITIVE, (Object[])new CharSequence[]{"open", "module", "requires", "exports", "opens", "uses", "provides", "transitive", "to", "with"});
    private final _JavaLexer myFlexLexer;
    private CharSequence myBuffer;
    private char[] myBufferArray;
    private int myBufferIndex;
    private int myBufferEndOffset;
    private int myTokenEndOffset;
    private IElementType myTokenType;

    public static boolean isKeyword(String id, @NotNull LanguageLevel level) {
        return KEYWORDS.contains(id) || level.isAtLeast(LanguageLevel.JDK_1_4) && "assert".equals(id) || level.isAtLeast(LanguageLevel.JDK_1_5) && "enum".equals(id);
    }

    public static boolean isSoftKeyword(CharSequence id, @NotNull LanguageLevel level) {
        return id != null && level.isAtLeast(LanguageLevel.JDK_1_9) && JAVA9_KEYWORDS.contains(id);
    }

    public JavaLexer(@NotNull LanguageLevel level) {
        this.myFlexLexer = new _JavaLexer(level);
    }

    public final void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myBuffer = buffer;
        this.myBufferArray = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)buffer);
        this.myBufferIndex = startOffset;
        this.myBufferEndOffset = endOffset;
        this.myTokenType = null;
        this.myTokenEndOffset = startOffset;
        this.myFlexLexer.reset(this.myBuffer, startOffset, endOffset, 0);
    }

    public int getState() {
        return 0;
    }

    public final IElementType getTokenType() {
        if (this.myTokenType == null) {
            this._locateToken();
        }
        return this.myTokenType;
    }

    public final int getTokenStart() {
        return this.myBufferIndex;
    }

    public final int getTokenEnd() {
        if (this.myTokenType == null) {
            this._locateToken();
        }
        return this.myTokenEndOffset;
    }

    public final void advance() {
        if (this.myTokenType == null) {
            this._locateToken();
        }
        this.myTokenType = null;
    }

    private void _locateToken() {
        if (this.myTokenEndOffset == this.myBufferEndOffset) {
            this.myTokenType = null;
            this.myBufferIndex = this.myBufferEndOffset;
            return;
        }
        this.myBufferIndex = this.myTokenEndOffset;
        char c = this.myBufferArray != null ? this.myBufferArray[this.myBufferIndex] : this.myBuffer.charAt(this.myBufferIndex);
        switch (c) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': {
                this.myTokenType = TokenType.WHITE_SPACE;
                this.myTokenEndOffset = this.getWhitespaces(this.myBufferIndex + 1);
                break;
            }
            case '/': {
                char nextChar;
                if (this.myBufferIndex + 1 >= this.myBufferEndOffset) {
                    this.myTokenType = JavaTokenType.DIV;
                    this.myTokenEndOffset = this.myBufferEndOffset;
                    break;
                }
                char c2 = nextChar = this.myBufferArray != null ? this.myBufferArray[this.myBufferIndex + 1] : this.myBuffer.charAt(this.myBufferIndex + 1);
                if (nextChar == '/') {
                    this.myTokenType = JavaTokenType.END_OF_LINE_COMMENT;
                    this.myTokenEndOffset = this.getLineTerminator(this.myBufferIndex + 2);
                    break;
                }
                if (nextChar == '*') {
                    if (this.myBufferIndex + 2 >= this.myBufferEndOffset || (this.myBufferArray != null ? this.myBufferArray[this.myBufferIndex + 2] : this.myBuffer.charAt(this.myBufferIndex + 2)) != '*' || this.myBufferIndex + 3 < this.myBufferEndOffset && (this.myBufferArray != null ? this.myBufferArray[this.myBufferIndex + 3] : this.myBuffer.charAt(this.myBufferIndex + 3)) == '/') {
                        this.myTokenType = JavaTokenType.C_STYLE_COMMENT;
                        this.myTokenEndOffset = this.getClosingComment(this.myBufferIndex + 2);
                        break;
                    }
                    this.myTokenType = JavaDocElementType.DOC_COMMENT;
                    this.myTokenEndOffset = this.getClosingComment(this.myBufferIndex + 3);
                    break;
                }
                this.flexLocateToken();
                break;
            }
            case '\"': 
            case '\'': {
                this.myTokenType = c == '\"' ? JavaTokenType.STRING_LITERAL : JavaTokenType.CHARACTER_LITERAL;
                this.myTokenEndOffset = this.getClosingParenthesis(this.myBufferIndex + 1, c);
                break;
            }
            default: {
                this.flexLocateToken();
            }
        }
        if (this.myTokenEndOffset > this.myBufferEndOffset) {
            this.myTokenEndOffset = this.myBufferEndOffset;
        }
    }

    private int getWhitespaces(int offset) {
        char c;
        if (offset >= this.myBufferEndOffset) {
            return this.myBufferEndOffset;
        }
        int pos = offset;
        char c2 = c = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
        while (c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f') {
            if (++pos == this.myBufferEndOffset) {
                return pos;
            }
            c = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
        }
        return pos;
    }

    private void flexLocateToken() {
        try {
            this.myFlexLexer.goTo(this.myBufferIndex);
            this.myTokenType = this.myFlexLexer.advance();
            this.myTokenEndOffset = this.myFlexLexer.getTokenEnd();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int getClosingParenthesis(int offset, char c) {
        int pos;
        block6: {
            char cur;
            if (offset >= this.myBufferEndOffset) {
                return this.myBufferEndOffset;
            }
            pos = offset;
            char c2 = cur = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
            while (true) {
                if (cur != c && cur != '\n' && cur != '\r' && cur != '\\') {
                    if (++pos >= this.myBufferEndOffset) {
                        return this.myBufferEndOffset;
                    }
                    cur = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
                    continue;
                }
                if (cur != '\\') break;
                if (++pos >= this.myBufferEndOffset) {
                    return this.myBufferEndOffset;
                }
                cur = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
                if (cur == '\n' || cur == '\r') continue;
                if (++pos >= this.myBufferEndOffset) {
                    return this.myBufferEndOffset;
                }
                cur = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
            }
            if (cur == c) break block6;
            --pos;
        }
        return pos + 1;
    }

    private int getClosingComment(int offset) {
        int pos;
        for (pos = offset; pos < this.myBufferEndOffset - 1; ++pos) {
            char c;
            char c2 = c = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
            if (c == '*' && (this.myBufferArray != null ? this.myBufferArray[pos + 1] : this.myBuffer.charAt(pos + 1)) == '/') break;
        }
        return pos + 2;
    }

    private int getLineTerminator(int offset) {
        int pos;
        for (pos = offset; pos < this.myBufferEndOffset; ++pos) {
            char c;
            char c2 = c = this.myBufferArray != null ? this.myBufferArray[pos] : this.myBuffer.charAt(pos);
            if (c == '\r' || c == '\n') break;
        }
        return pos;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        return this.myBuffer;
    }

    public final int getBufferEnd() {
        return this.myBufferEndOffset;
    }
}

