/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.mock.MockComponentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ModalityInvokator;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ThrowableComputable;
import java.awt.Component;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class MockApplication
extends MockComponentManager
implements Application {
    public static int INSTANCES_CREATED = 0;

    public MockApplication(@NotNull Disposable parentDisposable) {
        super(null, parentDisposable);
        ++INSTANCES_CREATED;
    }

    public boolean isInternal() {
        return false;
    }

    public boolean isEAP() {
        return false;
    }

    public boolean isDispatchThread() {
        return true;
    }

    public boolean isActive() {
        return true;
    }

    public void assertReadAccessAllowed() {
    }

    public void assertWriteAccessAllowed() {
    }

    public void assertIsDispatchThread() {
    }

    public boolean isReadAccessAllowed() {
        return true;
    }

    public boolean isWriteAccessAllowed() {
        return true;
    }

    public boolean isUnitTestMode() {
        return true;
    }

    public boolean isHeadlessEnvironment() {
        return true;
    }

    public boolean isCommandLine() {
        return true;
    }

    @NotNull
    public Future<?> executeOnPooledThread(@NotNull Runnable action) {
        return PooledThreadExecutor.INSTANCE.submit(action);
    }

    @NotNull
    public <T> Future<T> executeOnPooledThread(@NotNull Callable<T> action) {
        return PooledThreadExecutor.INSTANCE.submit(action);
    }

    public boolean isDisposeInProgress() {
        return false;
    }

    public boolean isRestartCapable() {
        return false;
    }

    public void restart() {
    }

    public void runReadAction(@NotNull Runnable action) {
        action.run();
    }

    public <T> T runReadAction(@NotNull Computable<T> computation) {
        return (T)computation.compute();
    }

    public <T, E extends Throwable> T runReadAction(@NotNull ThrowableComputable<T, E> computation) throws E {
        return (T)computation.compute();
    }

    public void runWriteAction(@NotNull Runnable action) {
        action.run();
    }

    public <T> T runWriteAction(@NotNull Computable<T> computation) {
        return (T)computation.compute();
    }

    public <T, E extends Throwable> T runWriteAction(@NotNull ThrowableComputable<T, E> computation) throws E {
        return (T)computation.compute();
    }

    @NotNull
    public AccessToken acquireReadActionLock() {
        return AccessToken.EMPTY_ACCESS_TOKEN;
    }

    @NotNull
    public AccessToken acquireWriteActionLock(@Nullable Class marker) {
        return AccessToken.EMPTY_ACCESS_TOKEN;
    }

    public boolean hasWriteAction(@NotNull Class<?> actionClass) {
        return false;
    }

    public void addApplicationListener(@NotNull ApplicationListener listener2) {
    }

    public void addApplicationListener(@NotNull ApplicationListener listener2, @NotNull Disposable parent) {
    }

    public void removeApplicationListener(@NotNull ApplicationListener listener2) {
    }

    public long getStartTime() {
        return 0L;
    }

    public long getIdleTime() {
        return 0L;
    }

    @NotNull
    public ModalityState getNoneModalityState() {
        return ModalityState.NON_MODAL;
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull Condition expired) {
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState state, @NotNull Condition expired) {
    }

    public void invokeLater(@NotNull Runnable runnable2) {
    }

    public void invokeLater(@NotNull Runnable runnable2, @NotNull ModalityState state) {
    }

    @NotNull
    public ModalityInvokator getInvokator() {
        throw new UnsupportedOperationException();
    }

    public void invokeAndWait(@NotNull Runnable runnable2, @NotNull ModalityState modalityState) {
    }

    public void invokeAndWait(@NotNull Runnable runnable2) throws ProcessCanceledException {
        this.invokeAndWait(runnable2, this.getDefaultModalityState());
    }

    @NotNull
    public ModalityState getCurrentModalityState() {
        return this.getNoneModalityState();
    }

    @NotNull
    public ModalityState getAnyModalityState() {
        return this.getNoneModalityState();
    }

    @NotNull
    public ModalityState getModalityStateForComponent(@NotNull Component c) {
        return this.getNoneModalityState();
    }

    @NotNull
    public ModalityState getDefaultModalityState() {
        return this.getNoneModalityState();
    }

    public void exit() {
    }

    public void saveAll() {
    }

    public void saveSettings() {
    }
}

