/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MockDocument
implements DocumentEx {
    private final Map myUserData = new HashMap();
    private StringBuffer myText = new StringBuffer();
    private long myModStamp = LocalTimeCounter.currentTime();

    @NotNull
    public String getText() {
        return this.myText.toString();
    }

    @NotNull
    public String getText(@NotNull TextRange range) {
        return range.substring(this.myText.toString());
    }

    @Override
    public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
        this.myText = new StringBuffer();
        this.myText.append(chars);
        this.myModStamp = newModificationStamp;
    }

    public CharSequence textToCharArray() {
        return this.getText();
    }

    @NotNull
    public char[] getChars() {
        return this.getText().toCharArray();
    }

    @NotNull
    public CharSequence getCharsSequence() {
        return this.getText();
    }

    @NotNull
    public CharSequence getImmutableCharSequence() {
        return this.getText();
    }

    public int getTextLength() {
        return this.myText.length();
    }

    public int getLineCount() {
        return 1;
    }

    public int getLineNumber(int offset) {
        return 0;
    }

    public int getLineStartOffset(int line) {
        return 0;
    }

    public int getLineEndOffset(int line) {
        return this.myText.length();
    }

    public void insertString(int offset, @NotNull CharSequence s) {
        this.myText.insert(offset, s);
    }

    public void deleteString(int startOffset, int endOffset) {
        this.myText.delete(startOffset, endOffset);
    }

    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        this.myText.replace(startOffset, endOffset, s.toString());
        this.myModStamp = LocalTimeCounter.currentTime();
    }

    @Override
    public void moveText(int srcStart, int srcEnd, int dstOffset) {
        throw new UnsupportedOperationException();
    }

    public boolean isWritable() {
        return false;
    }

    public long getModificationStamp() {
        return this.myModStamp;
    }

    public void fireReadOnlyModificationAttempt() {
    }

    public void addDocumentListener(@NotNull DocumentListener listener2) {
    }

    public void addDocumentListener(@NotNull DocumentListener listener2, @NotNull Disposable parentDisposable) {
    }

    public void removeDocumentListener(@NotNull DocumentListener listener2) {
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        throw new UnsupportedOperationException();
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    public <T> T getUserData(@NotNull Key<T> key2) {
        return (T)this.myUserData.get(key2);
    }

    public <T> void putUserData(@NotNull Key<T> key2, T value2) {
        this.myUserData.put(key2, value2);
    }

    @Override
    public void setStripTrailingSpacesEnabled(boolean isEnabled) {
    }

    public int getLineSeparatorLength(int line) {
        return 0;
    }

    @Override
    @NotNull
    public LineIterator createLineIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        this.myModStamp = modificationStamp;
    }

    public void setReadOnly(boolean isReadOnly) {
    }

    public RangeMarker getRangeGuard(int start, int end) {
        return null;
    }

    public void startGuardedBlockChecking() {
    }

    public void stopGuardedBlockChecking() {
    }

    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        throw new UnsupportedOperationException();
    }

    public void removeGuardedBlock(@NotNull RangeMarker block) {
    }

    public RangeMarker getOffsetGuard(int offset) {
        return null;
    }

    @Override
    public void addEditReadOnlyListener(@NotNull EditReadOnlyListener listener2) {
    }

    @Override
    public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener2) {
    }

    @Override
    public void suppressGuardedExceptions() {
    }

    @Override
    public void unSuppressGuardedExceptions() {
    }

    @Override
    public boolean isInEventsHandling() {
        return false;
    }

    @Override
    public void clearLineModificationFlags() {
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        return false;
    }

    @Override
    public void registerRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
    }

    @Override
    public boolean isInBulkUpdate() {
        return false;
    }

    @Override
    public void setInBulkUpdate(boolean value2) {
    }

    public void setCyclicBufferSize(int bufferSize) {
    }

    public void setText(@NotNull CharSequence text) {
    }

    @NotNull
    public RangeMarker createRangeMarker(@NotNull TextRange textRange) {
        return this.createRangeMarker(textRange.getStartOffset(), textRange.getEndOffset());
    }

    @Override
    @NotNull
    public List<RangeMarker> getGuardedBlocks() {
        return Collections.emptyList();
    }

    @Override
    public boolean processRangeMarkers(@NotNull Processor<? super RangeMarker> processor2) {
        return false;
    }

    @Override
    public boolean processRangeMarkersOverlappingWith(int start, int end, @NotNull Processor<? super RangeMarker> processor2) {
        return false;
    }

    @Override
    public int getModificationSequence() {
        return 0;
    }
}

