/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MockFileIndexFacade
extends FileIndexFacade {
    private final Module myModule = null;
    private final List<VirtualFile> myLibraryRoots = new ArrayList<VirtualFile>();

    public MockFileIndexFacade(Project project2) {
        super(project2);
    }

    public boolean isInContent(@NotNull VirtualFile file2) {
        return true;
    }

    public boolean isInSource(@NotNull VirtualFile file2) {
        return true;
    }

    public boolean isInSourceContent(@NotNull VirtualFile file2) {
        return true;
    }

    public boolean isInLibraryClasses(@NotNull VirtualFile file2) {
        for (VirtualFile libraryRoot : this.myLibraryRoots) {
            if (!VfsUtilCore.isAncestor((VirtualFile)libraryRoot, (VirtualFile)file2, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public boolean isInLibrarySource(@NotNull VirtualFile file2) {
        return false;
    }

    public boolean isExcludedFile(@NotNull VirtualFile file2) {
        return false;
    }

    public boolean isUnderIgnored(@NotNull VirtualFile file2) {
        return false;
    }

    public Module getModuleForFile(@NotNull VirtualFile file2) {
        return this.myModule;
    }

    public boolean isValidAncestor(@NotNull VirtualFile baseDir, @NotNull VirtualFile child) {
        return VfsUtilCore.isAncestor((VirtualFile)baseDir, (VirtualFile)child, (boolean)false);
    }

    @NotNull
    public ModificationTracker getRootModificationTracker() {
        return ModificationTracker.NEVER_CHANGED;
    }

    public void addLibraryRoot(VirtualFile file2) {
        this.myLibraryRoots.add(file2);
    }
}

