/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.util.containers.ConcurrentWeakFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockFileManager
implements FileManager {
    private final PsiManagerEx myManager;
    private final FactoryMap<VirtualFile, FileViewProvider> myViewProviders = new ConcurrentWeakFactoryMap<VirtualFile, FileViewProvider>(){

        protected Map<VirtualFile, FileViewProvider> createMap() {
            return ContainerUtil.createConcurrentWeakKeyWeakValueMap();
        }

        protected FileViewProvider create(VirtualFile key2) {
            return new SingleRootFileViewProvider(MockFileManager.this.myManager, key2);
        }
    };

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file2, boolean eventSystemEnabled) {
        return new SingleRootFileViewProvider(this.myManager, file2, eventSystemEnabled);
    }

    public MockFileManager(PsiManagerEx manager) {
        this.myManager = manager;
    }

    public void dispose() {
        throw new UnsupportedOperationException("Method dispose is not yet implemented in " + this.getClass().getName());
    }

    @Override
    @Nullable
    public PsiFile findFile(@NotNull VirtualFile vFile) {
        return this.getCachedPsiFile(vFile);
    }

    @Override
    @Nullable
    public PsiDirectory findDirectory(@NotNull VirtualFile vFile) {
        throw new UnsupportedOperationException("Method findDirectory is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile file2) {
        throw new UnsupportedOperationException("Method reloadFromDisk is not yet implemented in " + this.getClass().getName());
    }

    @Override
    @Nullable
    public PsiFile getCachedPsiFile(@NotNull VirtualFile vFile) {
        FileViewProvider provider2 = this.findCachedViewProvider(vFile);
        return provider2.getPsi(provider2.getBaseLanguage());
    }

    @Override
    public void cleanupForNextTest() {
        this.myViewProviders.clear();
    }

    @Override
    public FileViewProvider findViewProvider(@NotNull VirtualFile file2) {
        throw new UnsupportedOperationException("Method findViewProvider is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile file2) {
        return (FileViewProvider)this.myViewProviders.get((Object)file2);
    }

    @Override
    public void setViewProvider(@NotNull VirtualFile virtualFile, FileViewProvider fileViewProvider) {
        this.myViewProviders.put((Object)virtualFile, (Object)fileViewProvider);
    }

    @Override
    @NotNull
    public List<PsiFile> getAllCachedFiles() {
        throw new UnsupportedOperationException("Method getAllCachedFiles is not yet implemented in " + this.getClass().getName());
    }
}

