/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.mock.MockComponentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public class MockProject
extends MockComponentManager
implements Project {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.mock.MockProject");
    private VirtualFile myBaseDir;

    public MockProject(PicoContainer parent, @NotNull Disposable parentDisposable) {
        super(parent, parentDisposable);
        Extensions.instantiateArea((String)"IDEA_PROJECT", (AreaInstance)this, null);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                Extensions.disposeArea((AreaInstance)MockProject.this);
            }
        });
    }

    public boolean isDefault() {
        return false;
    }

    @Override
    @NotNull
    public Condition<?> getDisposed() {
        return o -> this.isDisposed();
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isInitialized() {
        return true;
    }

    public VirtualFile getProjectFile() {
        return null;
    }

    @NotNull
    public String getName() {
        return "";
    }

    @Nullable
    @NonNls
    public String getPresentableUrl() {
        return null;
    }

    @NotNull
    @NonNls
    public String getLocationHash() {
        return "mock";
    }

    @Nullable
    public String getProjectFilePath() {
        return null;
    }

    public VirtualFile getWorkspaceFile() {
        return null;
    }

    public void setBaseDir(VirtualFile baseDir) {
        this.myBaseDir = baseDir;
    }

    @Nullable
    public VirtualFile getBaseDir() {
        return this.myBaseDir;
    }

    @Nullable
    public String getBasePath() {
        return null;
    }

    public void save() {
    }

    @Override
    @NotNull
    public <T> T[] getExtensions(@NotNull ExtensionPointName<T> extensionPointName) {
        return Extensions.getArea((AreaInstance)this).getExtensionPoint(extensionPointName).getExtensions();
    }

    public void projectOpened() {
        ProjectComponent[] components;
        for (ProjectComponent component : components = this.getComponents(ProjectComponent.class)) {
            try {
                component.projectOpened();
            }
            catch (Throwable e) {
                LOG.error(component.toString(), e);
            }
        }
    }
}

